/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.index.Index;

public class DanglingIndicesState {
    private static final Logger logger = LogManager.getLogger(DanglingIndicesState.class);
    private final MetaStateService metaStateService;
    private final ClusterService clusterService;

    @Inject
    public DanglingIndicesState(MetaStateService metaStateService, ClusterService clusterService) {
        this.metaStateService = metaStateService;
        this.clusterService = clusterService;
    }

    public Map<Index, IndexMetadata> getDanglingIndices() {
        Metadata metadata = this.clusterService.state().metadata();
        Set<String> excludeIndexPathIds = Sets.newHashSetWithExpectedSize(metadata.indices().size());
        for (IndexMetadata indexMetadata : metadata.indices().values()) {
            excludeIndexPathIds.add(indexMetadata.getIndex().getUUID());
        }
        try {
            List<IndexMetadata> indexMetadataList = this.metaStateService.loadIndicesStates(excludeIndexPathIds::contains);
            HashMap<Index, IndexMetadata> danglingIndices = new HashMap<Index, IndexMetadata>();
            IndexGraveyard graveyard = metadata.indexGraveyard();
            for (IndexMetadata indexMetadata : indexMetadataList) {
                Index index = indexMetadata.getIndex();
                if (graveyard.containsIndex(index)) continue;
                danglingIndices.put(index, DanglingIndicesState.stripAliases(indexMetadata));
            }
            return danglingIndices;
        }
        catch (IOException e) {
            logger.warn("failed to list dangling indices", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static IndexMetadata stripAliases(IndexMetadata indexMetadata) {
        if (indexMetadata.getAliases().isEmpty()) {
            return indexMetadata;
        }
        logger.info("[{}] stripping aliases: {} from index before importing", (Object)indexMetadata.getIndex(), indexMetadata.getAliases().keySet());
        return IndexMetadata.builder(indexMetadata).removeAllAliases().build();
    }
}

