/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnFirstWriteMap<K, V>
implements Map<K, V> {
    private Map<K, V> source;
    private boolean wasCopied = false;

    public CopyOnFirstWriteMap(Map<K, V> source) {
        this.source = source;
    }

    private Map<K, V> getForUpdate() {
        if (!this.wasCopied) {
            this.source = new HashMap<K, V>(this.source);
            this.wasCopied = true;
        }
        return this.source;
    }

    private Map<K, V> getForRead() {
        return this.source;
    }

    public Map<K, V> toImmutableMap() {
        return Map.copyOf(this.getForRead());
    }

    @Override
    public int size() {
        return this.getForRead().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getForRead().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getForRead().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getForRead().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getForRead().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.getForUpdate().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.getForUpdate().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.getForUpdate().putAll(m);
    }

    @Override
    public void clear() {
        this.getForUpdate().clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.getForRead().keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.getForRead().values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.getForRead().entrySet());
    }
}

