/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.ByteArray;

final class BigByteArray
extends AbstractBigArray
implements ByteArray {
    private static final BigByteArray ESTIMATOR = new BigByteArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    private byte[][] pages;

    BigByteArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(16384, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newBytePage(i);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, Math.toIntExact(this.size), this.pages, 1, 16384);
    }

    @Override
    public byte get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public byte set(long index, byte value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        byte ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public boolean get(long index, int len, BytesRef ref) {
        assert (index + (long)len <= this.size());
        if (len == 0) {
            ref.length = 0;
            return false;
        }
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        if (indexInPage + len <= this.pageSize()) {
            ref.bytes = this.pages[pageIndex];
            ref.offset = indexInPage;
            ref.length = len;
            return false;
        }
        ref.bytes = new byte[len];
        ref.offset = 0;
        ref.length = this.pageSize() - indexInPage;
        System.arraycopy(this.pages[pageIndex], indexInPage, ref.bytes, 0, ref.length);
        do {
            int copyLength = Math.min(this.pageSize(), len - ref.length);
            System.arraycopy(this.pages[++pageIndex], 0, ref.bytes, ref.length, copyLength);
            ref.length += copyLength;
        } while (ref.length < len);
        return true;
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        assert (index + (long)len <= this.size());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        if (indexInPage + len <= this.pageSize()) {
            System.arraycopy(buf, offset, this.pages[pageIndex], indexInPage, len);
        } else {
            int copyLen = this.pageSize() - indexInPage;
            System.arraycopy(buf, offset, this.pages[pageIndex], indexInPage, copyLen);
            do {
                copyLen = Math.min(len -= copyLen, this.pageSize());
                System.arraycopy(buf, offset += copyLen, this.pages[++pageIndex], 0, copyLen);
            } while (len > copyLen);
        }
    }

    @Override
    public void fill(long fromIndex, long toIndex, byte value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        assert (false);
        throw new UnsupportedOperationException();
    }

    @Override
    protected int numBytesPerElement() {
        return 1;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newBytePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }
}

