/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CombineFunction implements Writeable
{
    MULTIPLY{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)(queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0]);
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
            return Explanation.match((Number)Float.valueOf(queryExpl.getValue().floatValue() * minExpl.getValue().floatValue()), (String)"function score, product of:", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    REPLACE{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.min(funcScore, maxBoost);
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0]);
            return Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
        }
    }
    ,
    SUM{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)(queryScore + Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost) + queryExpl.getValue().floatValue()), (String)"sum of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    AVG{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)((Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf((float)((double)(Math.min(funcExpl.getValue().floatValue(), maxBoost) + queryExpl.getValue().floatValue()) / 2.0)), (String)"avg of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    MIN{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.min(queryScore, Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.min(Math.min(funcExpl.getValue().floatValue(), maxBoost), queryExpl.getValue().floatValue())), (String)"min of", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    }
    ,
    MAX{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.max(queryScore, Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.max(Math.min(funcExpl.getValue().floatValue(), maxBoost), queryExpl.getValue().floatValue())), (String)"max of:", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    };


    public abstract float combine(double var1, double var3, double var5);

    public abstract Explanation explain(Explanation var1, Explanation var2, float var3);

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static CombineFunction readFromStream(StreamInput in) throws IOException {
        return in.readEnum(CombineFunction.class);
    }

    public static CombineFunction fromString(String combineFunction) {
        return CombineFunction.valueOf(combineFunction.toUpperCase(Locale.ROOT));
    }
}

