/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.elasticsearch.core.Nullable;

public class Iterators {
    public static <T> Iterator<T> single(final T element) {
        return new Iterator<T>(){
            private T value;
            {
                this.value = Objects.requireNonNull(element);
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public T next() {
                Object res = this.value;
                this.value = null;
                return res;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            throw new NullPointerException("iterators");
        }
        for (int i = 0; i < iterators.length; ++i) {
            if (!iterators[i].hasNext()) continue;
            return new ConcatenatedIterator<T>(iterators, i);
        }
        return Collections.emptyIterator();
    }

    public static <T> Iterator<T> forArray(T[] array) {
        return new ArrayIterator<T>(array);
    }

    public static <T> Iterator<T> forRange(int lowerBoundInclusive, int upperBoundExclusive, IntFunction<? extends T> fn) {
        assert (lowerBoundInclusive <= upperBoundExclusive) : lowerBoundInclusive + " vs " + upperBoundExclusive;
        if (upperBoundExclusive <= lowerBoundInclusive) {
            return Collections.emptyIterator();
        }
        return new IntRangeIterator<T>(lowerBoundInclusive, upperBoundExclusive, Objects.requireNonNull(fn));
    }

    public static <T, U> Iterator<U> map(Iterator<? extends T> input, Function<T, ? extends U> fn) {
        if (input.hasNext()) {
            if (input instanceof MapIterator) {
                MapIterator mapIterator = (MapIterator)input;
                return new MapIterator(mapIterator.input, mapIterator.fn.andThen(fn));
            }
            return new MapIterator<T, U>(input, fn);
        }
        return Collections.emptyIterator();
    }

    public static <T, U> Iterator<U> flatMap(Iterator<? extends T> input, Function<T, Iterator<? extends U>> fn) {
        while (input.hasNext()) {
            Iterator<U> value = fn.apply(input.next());
            if (!value.hasNext()) continue;
            return new FlatMapIterator<T, U>(input, fn, value);
        }
        return Collections.emptyIterator();
    }

    public static <T> boolean equals(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2, BiPredicate<T, T> itemComparer) {
        if (iterator1 == null) {
            return iterator2 == null;
        }
        if (iterator2 == null) {
            return false;
        }
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (itemComparer.test(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static <T> int hashCode(Iterator<? extends T> iterator, ToIntFunction<T> itemHashcode) {
        if (iterator == null) {
            return 0;
        }
        int result = 1;
        while (iterator.hasNext()) {
            result = 31 * result + itemHashcode.applyAsInt(iterator.next());
        }
        return result;
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T>[] iterators;
        private int index;

        ConcatenatedIterator(Iterator<? extends T>[] iterators, int startIndex) {
            for (int i = startIndex; i < iterators.length; ++i) {
                if (iterators[i] != null) continue;
                throw new NullPointerException("iterators[" + i + "]");
            }
            this.iterators = iterators;
            this.index = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.iterators.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T value = this.iterators[this.index].next();
            while (this.index < this.iterators.length && !this.iterators[this.index].hasNext()) {
                ++this.index;
            }
            return value;
        }
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] array;
        private int index;

        private ArrayIterator(T[] array) {
            this.array = Objects.requireNonNull(array, "Unable to iterate over a null array");
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public T next() {
            if (this.index >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }
    }

    private static final class IntRangeIterator<T>
    implements Iterator<T> {
        private final IntFunction<? extends T> fn;
        private final int upperBoundExclusive;
        private int index;

        IntRangeIterator(int lowerBoundInclusive, int upperBoundExclusive, IntFunction<? extends T> fn) {
            this.fn = fn;
            this.index = lowerBoundInclusive;
            this.upperBoundExclusive = upperBoundExclusive;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.upperBoundExclusive;
        }

        @Override
        public T next() {
            if (this.index >= this.upperBoundExclusive) {
                throw new NoSuchElementException();
            }
            return this.fn.apply(this.index++);
        }
    }

    private static final class MapIterator<T, U>
    implements Iterator<U> {
        private final Iterator<? extends T> input;
        private final Function<T, ? extends U> fn;

        MapIterator(Iterator<? extends T> input, Function<T, ? extends U> fn) {
            this.input = input;
            this.fn = fn;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public U next() {
            return this.fn.apply(this.input.next());
        }
    }

    private static final class FlatMapIterator<T, U>
    implements Iterator<U> {
        private final Iterator<? extends T> input;
        private final Function<T, Iterator<? extends U>> fn;
        @Nullable
        private Iterator<? extends U> currentOutput;

        FlatMapIterator(Iterator<? extends T> input, Function<T, Iterator<? extends U>> fn, Iterator<? extends U> firstOutput) {
            this.input = input;
            this.fn = fn;
            this.currentOutput = firstOutput;
        }

        @Override
        public boolean hasNext() {
            return this.currentOutput != null;
        }

        @Override
        public U next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.currentOutput != null && this.currentOutput.hasNext());
            U value = this.currentOutput.next();
            while (this.currentOutput != null && !this.currentOutput.hasNext()) {
                if (this.input.hasNext()) {
                    this.currentOutput = this.fn.apply(this.input.next());
                    continue;
                }
                this.currentOutput = null;
            }
            return value;
        }
    }
}

