/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean sameHost;
    private static final Decision YES_NONE_HOLD_COPY = Decision.single(Decision.Type.YES, "same_shard", "none of the nodes on this host hold a copy of this shard", new Object[0]);
    private static final Decision YES_AUTO_EXPAND_ALL = Decision.single(Decision.Type.YES, "same_shard", "same-host allocation is ignored, this index is set to auto-expand to all nodes", new Object[0]);
    private static final Decision YES_NO_COPY = Decision.single(Decision.Type.YES, "same_shard", "this node does not hold a copy of this shard", new Object[0]);

    public SameShardAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, this::setSameHost);
    }

    private void setSameHost(boolean sameHost) {
        this.sameHost = sameHost;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        Decision decision = SameShardAllocationDecider.decideSameNode(shardRouting, node, allocation, assignedShards);
        if (decision.type() == Decision.Type.NO || !this.sameHost) {
            return decision;
        }
        if (allocation.metadata().getIndexSafe(shardRouting.index()).getAutoExpandReplicas().expandToAllNodes()) {
            return YES_AUTO_EXPAND_ALL;
        }
        if (node.node() != null) {
            assert (Strings.hasLength(node.node().getHostAddress())) : node;
            for (ShardRouting assignedShard : assignedShards) {
                DiscoveryNode checkNode = allocation.nodes().get(assignedShard.currentNodeId());
                assert (checkNode != null);
                assert (Strings.hasLength(checkNode.getHostAddress())) : checkNode;
                if (!checkNode.getHostAddress().equals(node.node().getHostAddress())) continue;
                return allocation.debugDecision() ? SameShardAllocationDecider.debugNoAlreadyAllocatedToHost(node, checkNode, allocation) : Decision.NO;
            }
        }
        return YES_NONE_HOLD_COPY;
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static Decision debugNoAlreadyAllocatedToHost(RoutingNode newNode, DiscoveryNode existingNode, RoutingAllocation allocation) {
        return allocation.decision(Decision.NO, NAME, "cannot allocate to node [%s] because a copy of this shard is already allocated to node [%s] with the same host address [%s] and [%s] is [true] which forbids more than one node on each host from holding a copy of this shard", newNode.nodeId(), existingNode.getId(), newNode.node().getHostAddress(), CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.getKey());
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call force allocate on a non-primary shard";
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        return SameShardAllocationDecider.decideSameNode(shardRouting, node, allocation, assignedShards);
    }

    private static Decision decideSameNode(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, Iterable<ShardRouting> assignedShards) {
        boolean debug = allocation.debugDecision();
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            return debug ? SameShardAllocationDecider.debugNo(shardRouting, assignedShard) : Decision.NO;
        }
        return YES_NO_COPY;
    }

    private static Decision debugNo(ShardRouting shardRouting, ShardRouting assignedShard) {
        String explanation = assignedShard.isSameAllocation(shardRouting) ? "this shard is already allocated to this node [" + shardRouting.toString() + "]" : "a copy of this shard is already allocated to this node [" + assignedShard + "]";
        return Decision.single(Decision.Type.NO, NAME, explanation, new Object[0]);
    }
}

