/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.desirednodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.core.Nullable;

public class DesiredNodesSettingsValidator
implements Consumer<List<DesiredNode>> {
    @Override
    public void accept(List<DesiredNode> nodes) {
        ArrayList<DesiredNodeValidationError> validationErrors = new ArrayList<DesiredNodeValidationError>();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            DesiredNode node = nodes.get(i2);
            if (!node.version().before(Version.CURRENT)) continue;
            validationErrors.add(new DesiredNodeValidationError(i2, node.externalId(), new IllegalArgumentException(String.format(Locale.ROOT, "Illegal node version [%s]. Only [%s] or newer versions are supported", node.version(), Build.current().version()))));
        }
        if (!validationErrors.isEmpty()) {
            String nodeIndicesWithFailures = validationErrors.stream().map(DesiredNodeValidationError::position).map(i -> Integer.toString(i)).collect(Collectors.joining(","));
            String nodeIdsWithFailures = validationErrors.stream().map(DesiredNodeValidationError::externalId).collect(Collectors.joining(","));
            IllegalArgumentException invalidSettingsException = new IllegalArgumentException(String.format(Locale.ROOT, "Nodes with ids [%s] in positions [%s] contain invalid settings", nodeIdsWithFailures, nodeIndicesWithFailures));
            for (DesiredNodeValidationError exceptionTuple : validationErrors) {
                invalidSettingsException.addSuppressed(exceptionTuple.exception);
            }
            throw invalidSettingsException;
        }
    }

    private record DesiredNodeValidationError(int position, @Nullable String externalId, RuntimeException exception) {
    }
}

