/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class JoinRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final CompatibilityVersions compatibilityVersions;
    private final Set<String> features;
    private final long minimumTerm;
    private final Optional<Join> optionalJoin;

    public JoinRequest(DiscoveryNode sourceNode, CompatibilityVersions compatibilityVersions, Set<String> features, long minimumTerm, Optional<Join> optionalJoin) {
        assert (!optionalJoin.isPresent() || optionalJoin.get().votingNode().equals(sourceNode));
        this.sourceNode = sourceNode;
        this.compatibilityVersions = compatibilityVersions;
        this.features = features;
        this.minimumTerm = minimumTerm;
        this.optionalJoin = optionalJoin;
    }

    public JoinRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.compatibilityVersions = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? CompatibilityVersions.readVersion(in) : new CompatibilityVersions(TransportVersion.fromId(this.sourceNode.getPre811VersionId().getAsInt()), Map.of());
        this.features = in.getTransportVersion().onOrAfter(TransportVersions.CLUSTER_FEATURES_ADDED) ? in.readCollectionAsSet(StreamInput::readString) : Set.of();
        this.minimumTerm = in.readLong();
        this.optionalJoin = Optional.ofNullable(in.readOptionalWriteable(Join::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            this.compatibilityVersions.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.CLUSTER_FEATURES_ADDED)) {
            out.writeCollection(this.features, StreamOutput::writeString);
        }
        out.writeLong(this.minimumTerm);
        out.writeOptionalWriteable(this.optionalJoin.orElse(null));
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public CompatibilityVersions getCompatibilityVersions() {
        return this.compatibilityVersions;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public long getMinimumTerm() {
        return this.minimumTerm;
    }

    public long getTerm() {
        return Math.max(this.minimumTerm, this.optionalJoin.map(Join::term).orElse(0L));
    }

    public Optional<Join> getOptionalJoin() {
        return this.optionalJoin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinRequest)) {
            return false;
        }
        JoinRequest that = (JoinRequest)o;
        if (this.minimumTerm != that.minimumTerm) {
            return false;
        }
        if (!this.sourceNode.equals(that.sourceNode)) {
            return false;
        }
        if (!this.compatibilityVersions.equals(that.compatibilityVersions)) {
            return false;
        }
        if (!this.features.equals(that.features)) {
            return false;
        }
        return this.optionalJoin.equals(that.optionalJoin);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.compatibilityVersions, this.features, this.minimumTerm, this.optionalJoin);
    }

    @Override
    public String toString() {
        return "JoinRequest{sourceNode=" + this.sourceNode + ", compatibilityVersions=" + this.compatibilityVersions + ", features=" + this.features + ", minimumTerm=" + this.minimumTerm + ", optionalJoin=" + this.optionalJoin + "}";
    }
}

