/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.stream.Stream;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.TransportMessage;

class ArraySearchPhaseResults<Result extends SearchPhaseResult>
extends SearchPhaseResults<Result> {
    final AtomicArray<Result> results;
    private final RefCounted refCounted = LeakTracker.wrap((RefCounted)AbstractRefCounted.of(this::doClose));

    ArraySearchPhaseResults(int size) {
        super(size);
        this.results = new AtomicArray(size);
    }

    @Override
    Stream<Result> getSuccessfulResults() {
        return this.results.asList().stream();
    }

    @Override
    void consumeResult(Result result, Runnable next) {
        assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
        this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        ((TransportMessage)result).incRef();
        next.run();
    }

    protected void doClose() {
        for (SearchPhaseResult result : this.getAtomicArray().asList()) {
            result.decRef();
        }
    }

    @Override
    boolean hasResult(int shardIndex) {
        return this.results.get(shardIndex) != null;
    }

    @Override
    AtomicArray<Result> getAtomicArray() {
        return this.results;
    }

    public void incRef() {
        this.refCounted.incRef();
    }

    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    public boolean decRef() {
        return this.refCounted.decRef();
    }

    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }
}

