/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiGetFomTranslogAction
extends HandledTransportAction<Request, Response> {
    public static final String NAME = "internal:data/read/mget_from_translog[shard]";
    public static final Logger logger = LogManager.getLogger(TransportShardMultiGetFomTranslogAction.class);
    private final IndicesService indicesService;

    protected TransportShardMultiGetFomTranslogAction(TransportService transportService, IndicesService indicesService, ActionFilters actionFilters) {
        super(NAME, transportService, actionFilters, Request::new, transportService.getThreadPool().executor("get"));
        this.indicesService = indicesService;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        MultiGetShardRequest multiGetShardRequest = request.getMultiGetShardRequest();
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        assert (indexShard.routingEntry().isPromotableToPrimary()) : "not an indexing shard" + indexShard.routingEntry();
        assert (multiGetShardRequest.realtime());
        ActionListener.completeWith(listener, () -> {
            MultiGetShardResponse multiGetShardResponse = new MultiGetShardResponse();
            boolean someItemsNotFoundInTranslog = false;
            for (int i = 0; i < multiGetShardRequest.locations.size(); ++i) {
                MultiGetRequest.Item item = multiGetShardRequest.items.get(i);
                try {
                    GetResult result = indexShard.getService().getFromTranslog(item.id(), item.storedFields(), multiGetShardRequest.realtime(), item.version(), item.versionType(), item.fetchSourceContext(), multiGetShardRequest.isForceSyntheticSource());
                    GetResponse getResponse = null;
                    if (result == null) {
                        someItemsNotFoundInTranslog = true;
                    } else {
                        getResponse = new GetResponse(result);
                    }
                    multiGetShardResponse.add((int)multiGetShardRequest.locations.get(i), getResponse);
                    continue;
                }
                catch (IOException | RuntimeException e) {
                    if (TransportActions.isShardNotAvailableException(e)) {
                        throw e;
                    }
                    logger.debug("failed to execute multi_get_from_translog for {}[id={}]: {}", new Object[]{shardId, item.id(), e});
                    multiGetShardResponse.add((int)multiGetShardRequest.locations.get(i), new MultiGetResponse.Failure(multiGetShardRequest.index(), item.id(), e));
                }
            }
            long segmentGeneration = -1L;
            if (someItemsNotFoundInTranslog) {
                Engine engine = indexShard.getEngineOrNull();
                if (engine == null) {
                    throw new AlreadyClosedException("engine closed");
                }
                segmentGeneration = ((InternalEngine)engine).getLastUnsafeSegmentGenerationForGets();
            }
            return new Response(multiGetShardResponse, indexShard.getOperationPrimaryTerm(), segmentGeneration);
        });
    }

    public static class Request
    extends ActionRequest {
        private final MultiGetShardRequest multiGetShardRequest;
        private final ShardId shardId;

        public Request(MultiGetShardRequest multiGetShardRequest, ShardId shardId) {
            this.multiGetShardRequest = multiGetShardRequest;
            this.shardId = shardId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.multiGetShardRequest = new MultiGetShardRequest(in);
            this.shardId = new ShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.multiGetShardRequest.writeTo(out);
            this.shardId.writeTo(out);
        }

        public MultiGetShardRequest getMultiGetShardRequest() {
            return this.multiGetShardRequest;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public String toString() {
            return "ShardMultiGetFomTranslogRequest{multiGetShardRequest=" + this.multiGetShardRequest + ", shardId=" + this.shardId + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            return Objects.equals(this.shardId, other.shardId) && Objects.equals(this.multiGetShardRequest, other.multiGetShardRequest);
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.multiGetShardRequest);
        }
    }

    public static class Response
    extends ActionResponse {
        private final MultiGetShardResponse multiGetShardResponse;
        private final long primaryTerm;
        private final long segmentGeneration;

        public Response(MultiGetShardResponse response, long primaryTerm, long segmentGeneration) {
            this.primaryTerm = primaryTerm;
            this.segmentGeneration = segmentGeneration;
            this.multiGetShardResponse = response;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.segmentGeneration = in.readZLong();
            this.multiGetShardResponse = new MultiGetShardResponse(in);
            this.primaryTerm = in.getTransportVersion().onOrAfter(TransportVersions.PRIMARY_TERM_ADDED) ? in.readVLong() : -1L;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.segmentGeneration);
            this.multiGetShardResponse.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.PRIMARY_TERM_ADDED)) {
                out.writeVLong(this.primaryTerm);
            }
        }

        public long segmentGeneration() {
            return this.segmentGeneration;
        }

        public long primaryTerm() {
            return this.primaryTerm;
        }

        public MultiGetShardResponse multiGetShardResponse() {
            return this.multiGetShardResponse;
        }

        public String toString() {
            return Strings.format("ShardMultiGetFomTranslogResponse{multiGetShardResponse=%s, primaryTerm=%d, segmentGeneration=%d}", this.multiGetShardResponse, this.primaryTerm, this.segmentGeneration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response response = (Response)o;
            return this.segmentGeneration == response.segmentGeneration && Objects.equals(this.multiGetShardResponse, response.multiGetShardResponse) && this.primaryTerm == response.primaryTerm;
        }

        public int hashCode() {
            return Objects.hash(this.segmentGeneration, this.multiGetShardResponse, this.primaryTerm);
        }
    }
}

