/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.admin.indices.refresh.TransportShardRefreshAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetFromTranslogAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportSingleShardAction<GetRequest, GetResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetAction.class);
    private final IndicesService indicesService;
    private final ExecutorSelector executorSelector;
    private final NodeClient client;

    @Inject
    public TransportGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ExecutorSelector executorSelector, NodeClient client) {
        super("indices:data/read/get", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetRequest::new, threadPool.executor("get"));
        this.indicesService = indicesService;
        this.executorSelector = executorSelector;
        this.client = client;
        new TransportGetFromTranslogAction(transportService, indicesService, actionFilters);
    }

    @Override
    protected boolean resolveIndex(GetRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ShardIterator iterator = this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).preference());
        if (iterator == null) {
            return null;
        }
        return new PlainShardIterator(iterator.shardId(), iterator.getShardRoutings().stream().filter(shardRouting -> OperationRouting.canSearchShard(shardRouting, state)).toList());
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((GetRequest)request.request()).routing(state.metadata().resolveIndexRouting(((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
    }

    @Override
    protected void asyncShardOperation(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (!indexShard.routingEntry().isPromotableToPrimary()) {
            assert (!indexShard.indexSettings().isFastRefresh()) : "a search shard should not receive a TransportGetAction for an index with fast refresh";
            this.handleGetOnUnpromotableShard(request, indexShard, listener);
            return;
        }
        assert (!DiscoveryNode.isStateless(this.clusterService.getSettings()) || indexShard.indexSettings().isFastRefresh()) : "in Stateless a promotable to primary shard can receive a TransportGetAction only if an index has the fast refresh setting";
        if (request.realtime()) {
            this.asyncGet(request, shardId, listener);
        } else {
            indexShard.ensureShardSearchActive(b -> {
                try {
                    this.asyncGet(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, ShardId shardId) throws IOException {
        IndexShard indexShard = this.getIndexShard(shardId);
        GetResult result = indexShard.getService().get(request.id(), request.storedFields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext(), request.isForceSyntheticSource());
        return new GetResponse(result);
    }

    @Override
    protected Writeable.Reader<GetResponse> getResponseReader() {
        return GetResponse::new;
    }

    @Override
    protected Executor getExecutor(GetRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().getIndexSafe(shardId.getIndex()).isSystem()) {
            return this.threadPool.executor(this.executorSelector.executorForGet(shardId.getIndexName()));
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return this.threadPool.executor("search_throttled");
        }
        return super.getExecutor(request, shardId);
    }

    private void asyncGet(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        if (request.refresh() && !request.realtime()) {
            this.getExecutor(request, shardId).execute(ActionRunnable.wrap(listener, l -> {
                IndexShard indexShard = this.getIndexShard(shardId);
                indexShard.externalRefresh("refresh_flag_get", l.map(r -> this.shardOperation(request, shardId)));
            }));
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    private void handleGetOnUnpromotableShard(GetRequest request, IndexShard indexShard, ActionListener<GetResponse> listener) throws IOException {
        ShardId shardId = indexShard.shardId();
        DiscoveryNode node = TransportGetAction.getCurrentNodeOfPrimary(this.clusterService.state(), shardId);
        if (request.refresh()) {
            logger.trace("send refresh action for shard {} to node {}", new Object[]{shardId, node.getId()});
            BasicReplicationRequest refreshRequest = new BasicReplicationRequest(shardId);
            refreshRequest.setParentTask(request.getParentTask());
            this.client.executeLocally(TransportShardRefreshAction.TYPE, refreshRequest, listener.delegateFailureAndWrap((l, replicationResponse) -> super.asyncShardOperation(request, shardId, l)));
        } else if (request.realtime()) {
            TransportGetFromTranslogAction.Request getFromTranslogRequest = new TransportGetFromTranslogAction.Request(request, shardId);
            getFromTranslogRequest.setParentTask(request.getParentTask());
            this.transportService.sendRequest(node, "indices:data/read/get_from_translog", getFromTranslogRequest, new ActionListenerResponseHandler<TransportGetFromTranslogAction.Response>(listener.delegateFailure((l, r) -> {
                if (r.getResult() != null) {
                    logger.debug("received result for real-time get for id '{}' from promotable shard", new Object[]{request.id()});
                    l.onResponse(new GetResponse(r.getResult()));
                } else {
                    logger.debug("no result for real-time get for id '{}' from promotable shard (segment generation to wait for: {})", new Object[]{request.id(), r.segmentGeneration()});
                    if (r.segmentGeneration() == -1L) {
                        ActionRunnable.supply(l, () -> this.shardOperation(request, shardId)).run();
                    } else {
                        assert (r.segmentGeneration() > -1L);
                        assert (r.primaryTerm() > -1L);
                        indexShard.waitForPrimaryTermAndGeneration(r.primaryTerm(), r.segmentGeneration(), listener.delegateFailureAndWrap((ll, aLong) -> super.asyncShardOperation(request, shardId, ll)));
                    }
                }
            }), TransportGetFromTranslogAction.Response::new, this.getExecutor(request, shardId)));
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    static DiscoveryNode getCurrentNodeOfPrimary(ClusterState clusterState, ShardId shardId) {
        IndexShardRoutingTable shardRoutingTable = clusterState.routingTable().shardRoutingTable(shardId);
        if (shardRoutingTable.primaryShard() == null || !shardRoutingTable.primaryShard().active()) {
            throw new NoShardAvailableActionException(shardId, "primary shard is not active");
        }
        DiscoveryNode node = clusterState.nodes().get(shardRoutingTable.primaryShard().currentNodeId());
        assert (node != null);
        return node;
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }
}

