/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class GetRequest
extends SingleShardRequest<GetRequest>
implements RealtimeRequest {
    private String id;
    private String routing;
    private String preference;
    private String[] storedFields;
    private FetchSourceContext fetchSourceContext;
    private boolean refresh = false;
    boolean realtime = true;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;
    private boolean forceSyntheticSource = false;

    public GetRequest() {
    }

    GetRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readString();
        }
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.storedFields = in.readOptionalStringArray();
        this.realtime = in.readBoolean();
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = in.readLong();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::readFrom);
        this.forceSyntheticSource = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeOptionalStringArray(this.storedFields);
        out.writeBoolean(this.realtime);
        out.writeByte(this.versionType.getValue());
        out.writeLong(this.version);
        out.writeOptionalWriteable(this.fetchSourceContext);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeBoolean(this.forceSyntheticSource);
        } else if (this.forceSyntheticSource) {
            throw new IllegalArgumentException("force_synthetic_source is not supported before 8.4.0");
        }
    }

    public GetRequest(String index) {
        super(index);
    }

    public GetRequest(String index, String id) {
        super(index);
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public GetRequest storedFields(String ... fields) {
        this.storedFields = fields;
        return this;
    }

    public String[] storedFields() {
        return this.storedFields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public GetRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public long version() {
        return this.version;
    }

    public GetRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    public void setForceSyntheticSource(boolean forceSyntheticSource) {
        this.forceSyntheticSource = forceSyntheticSource;
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    @Override
    public String toString() {
        return "get [" + this.index + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

