/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetComposableIndexTemplateAction
extends ActionType<Response> {
    public static final GetComposableIndexTemplateAction INSTANCE = new GetComposableIndexTemplateAction();
    public static final String NAME = "indices:admin/index_template/get";

    private GetComposableIndexTemplateAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField NAME = new ParseField("name", new String[0]);
        public static final ParseField INDEX_TEMPLATES = new ParseField("index_templates", new String[0]);
        public static final ParseField INDEX_TEMPLATE = new ParseField("index_template", new String[0]);
        private final Map<String, ComposableIndexTemplate> indexTemplates;
        private final RolloverConfiguration rolloverConfiguration;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.indexTemplates = in.readMap(ComposableIndexTemplate::new);
            this.rolloverConfiguration = in.getTransportVersion().onOrAfter(TransportVersions.V_8_500_020) ? in.readOptionalWriteable(RolloverConfiguration::new) : null;
        }

        public Response(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.indexTemplates = indexTemplates;
            this.rolloverConfiguration = null;
        }

        public Response(Map<String, ComposableIndexTemplate> indexTemplates, RolloverConfiguration rolloverConfiguration) {
            this.indexTemplates = indexTemplates;
            this.rolloverConfiguration = rolloverConfiguration;
        }

        public Map<String, ComposableIndexTemplate> indexTemplates() {
            return this.indexTemplates;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.indexTemplates, StreamOutput::writeWriteable);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_500_020)) {
                out.writeOptionalWriteable(this.rolloverConfiguration);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return Objects.equals(this.indexTemplates, that.indexTemplates) && Objects.equals(this.rolloverConfiguration, that.rolloverConfiguration);
        }

        public int hashCode() {
            return Objects.hash(this.indexTemplates, this.rolloverConfiguration);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(INDEX_TEMPLATES.getPreferredName());
            for (Map.Entry<String, ComposableIndexTemplate> indexTemplate : this.indexTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), indexTemplate.getKey());
                builder.field(INDEX_TEMPLATE.getPreferredName());
                indexTemplate.getValue().toXContent(builder, params, this.rolloverConfiguration);
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        @Nullable
        private final String name;
        private boolean includeDefaults;

        public Request(@Nullable String name) {
            if (name != null && name.contains(",")) {
                throw new IllegalArgumentException("template name may not contain ','");
            }
            this.name = name;
            this.includeDefaults = false;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readOptionalString();
            this.includeDefaults = in.getTransportVersion().onOrAfter(TransportVersions.V_8_500_020) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.name);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_500_020)) {
                out.writeBoolean(this.includeDefaults);
            }
        }

        public void includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.name, other.name);
        }
    }
}

