/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;

public class ResizeRequestBuilder
extends AcknowledgedRequestBuilder<ResizeRequest, ResizeResponse, ResizeRequestBuilder> {
    public ResizeRequestBuilder(ElasticsearchClient client) {
        super(client, ResizeAction.INSTANCE, new ResizeRequest());
    }

    public ResizeRequestBuilder setTargetIndex(CreateIndexRequest request) {
        ((ResizeRequest)this.request).setTargetIndex(request);
        return this;
    }

    public ResizeRequestBuilder setSourceIndex(String index) {
        ((ResizeRequest)this.request).setSourceIndex(index);
        return this;
    }

    public ResizeRequestBuilder setSettings(Settings settings) {
        ((ResizeRequest)this.request).getTargetIndexRequest().settings(settings);
        return this;
    }

    public ResizeRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((ResizeRequest)this.request).setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public ResizeRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ResizeRequestBuilder setResizeType(ResizeType type) {
        ((ResizeRequest)this.request).setResizeType(type);
        return this;
    }

    public ResizeRequestBuilder setMaxPrimaryShardSize(ByteSizeValue maxPrimaryShardSize) {
        ((ResizeRequest)this.request).setMaxPrimaryShardSize(maxPrimaryShardSize);
        return this;
    }
}

