/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxPrimaryShardDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxPrimaryShardSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MinPrimaryShardDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MinPrimaryShardSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinSizeCondition;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RolloverConditions
implements Writeable,
ToXContentObject {
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("rollover_conditions");
    public static final ParseField MAX_AGE_FIELD = new ParseField("max_age", new String[0]);
    public static final ParseField MAX_DOCS_FIELD = new ParseField("max_docs", new String[0]);
    public static final ParseField MAX_SIZE_FIELD = new ParseField("max_size", new String[0]);
    public static final ParseField MAX_PRIMARY_SHARD_SIZE_FIELD = new ParseField("max_primary_shard_size", new String[0]);
    public static final ParseField MAX_PRIMARY_SHARD_DOCS_FIELD = new ParseField("max_primary_shard_docs", new String[0]);
    public static final ParseField MIN_AGE_FIELD = new ParseField("min_age", new String[0]);
    public static final ParseField MIN_DOCS_FIELD = new ParseField("min_docs", new String[0]);
    public static final ParseField MIN_SIZE_FIELD = new ParseField("min_size", new String[0]);
    public static final ParseField MIN_PRIMARY_SHARD_SIZE_FIELD = new ParseField("min_primary_shard_size", new String[0]);
    public static final ParseField MIN_PRIMARY_SHARD_DOCS_FIELD = new ParseField("min_primary_shard_docs", new String[0]);
    private final Map<String, Condition<?>> conditions;

    public RolloverConditions() {
        this.conditions = Map.of();
    }

    public RolloverConditions(StreamInput in) throws IOException {
        int size = in.readVInt();
        Map<String, Condition> conditions = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            Condition condition = in.readNamedWriteable(Condition.class);
            conditions.put(condition.name, condition);
        }
        this.conditions = Collections.unmodifiableMap(conditions);
    }

    public RolloverConditions(Map<String, Condition<?>> conditions) {
        this.conditions = Collections.unmodifiableMap(conditions);
    }

    public boolean hasMaxConditions() {
        return this.conditions.values().stream().anyMatch(c -> Condition.Type.MAX == c.type());
    }

    public boolean hasMinConditions() {
        return this.conditions.values().stream().anyMatch(c -> Condition.Type.MIN == c.type());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(this.conditions.values().stream().filter(c -> c.includedInVersion(out.getTransportVersion())).toList());
    }

    @Nullable
    public ByteSizeValue getMaxSize() {
        return this.conditions.containsKey("max_size") ? (ByteSizeValue)this.conditions.get("max_size").value() : null;
    }

    @Nullable
    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.conditions.containsKey("max_primary_shard_size") ? (ByteSizeValue)this.conditions.get("max_primary_shard_size").value() : null;
    }

    @Nullable
    public TimeValue getMaxAge() {
        return this.conditions.containsKey("max_age") ? (TimeValue)this.conditions.get("max_age").value() : null;
    }

    @Nullable
    public Long getMaxDocs() {
        return this.conditions.containsKey("max_docs") ? (Long)this.conditions.get("max_docs").value() : null;
    }

    @Nullable
    public Long getMaxPrimaryShardDocs() {
        return this.conditions.containsKey("max_primary_shard_docs") ? (Long)this.conditions.get("max_primary_shard_docs").value() : null;
    }

    @Nullable
    public ByteSizeValue getMinSize() {
        return this.conditions.containsKey("min_size") ? (ByteSizeValue)this.conditions.get("min_size").value() : null;
    }

    @Nullable
    public ByteSizeValue getMinPrimaryShardSize() {
        return this.conditions.containsKey("min_primary_shard_size") ? (ByteSizeValue)this.conditions.get("min_primary_shard_size").value() : null;
    }

    @Nullable
    public TimeValue getMinAge() {
        return this.conditions.containsKey("min_age") ? (TimeValue)this.conditions.get("min_age").value() : null;
    }

    @Nullable
    public Long getMinDocs() {
        return this.conditions.containsKey("min_docs") ? (Long)this.conditions.get("min_docs").value() : null;
    }

    @Nullable
    public Long getMinPrimaryShardDocs() {
        return this.conditions.containsKey("min_primary_shard_docs") ? (Long)this.conditions.get("min_primary_shard_docs").value() : null;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public boolean areConditionsMet(Map<String, Boolean> conditionResults) {
        boolean allMinConditionsMet = this.conditions.values().stream().filter(c -> Condition.Type.MIN == c.type()).allMatch(c -> conditionResults.getOrDefault(c.toString(), false));
        boolean anyMaxConditionsMet = this.conditions.values().stream().filter(c -> Condition.Type.MAX == c.type()).anyMatch(c -> conditionResults.getOrDefault(c.toString(), false));
        return conditionResults.size() == 0 || allMinConditionsMet && anyMaxConditionsMet;
    }

    public static RolloverConditions fromXContent(XContentParser parser) throws IOException {
        Builder builder = RolloverConditions.newBuilder();
        PARSER.parse(parser, (Object)builder, null);
        return builder.build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloverConditions that = (RolloverConditions)o;
        return Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.conditions);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder newBuilder(RolloverConditions conditions) {
        return new Builder(new HashMap(conditions.conditions));
    }

    public static Builder newBuilder() {
        return new Builder(new HashMap());
    }

    static {
        PARSER.declareString((builder, s) -> builder.addMaxIndexAgeCondition(TimeValue.parseTimeValue((String)s, (String)"max_age")), MAX_AGE_FIELD);
        PARSER.declareLong(Builder::addMaxIndexDocsCondition, MAX_DOCS_FIELD);
        PARSER.declareString((builder, s) -> builder.addMaxIndexSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_size")), MAX_SIZE_FIELD);
        PARSER.declareString((builder, s) -> builder.addMaxPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_primary_shard_size")), MAX_PRIMARY_SHARD_SIZE_FIELD);
        PARSER.declareLong(Builder::addMaxPrimaryShardDocsCondition, MAX_PRIMARY_SHARD_DOCS_FIELD);
        PARSER.declareString((builder, s) -> builder.addMinIndexAgeCondition(TimeValue.parseTimeValue((String)s, (String)"min_age")), MIN_AGE_FIELD);
        PARSER.declareLong(Builder::addMinIndexDocsCondition, MIN_DOCS_FIELD);
        PARSER.declareString((builder, s) -> builder.addMinIndexSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "min_size")), MIN_SIZE_FIELD);
        PARSER.declareString((builder, s) -> builder.addMinPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "min_primary_shard_size")), MIN_PRIMARY_SHARD_SIZE_FIELD);
        PARSER.declareLong(Builder::addMinPrimaryShardDocsCondition, MIN_PRIMARY_SHARD_DOCS_FIELD);
    }

    public static class Builder {
        private final Map<String, Condition<?>> conditions;

        private Builder(Map<String, Condition<?>> conditions) {
            this.conditions = conditions;
        }

        public Builder addMaxIndexAgeCondition(TimeValue age) {
            if (age != null) {
                MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
                this.conditions.put(maxAgeCondition.name, maxAgeCondition);
            }
            return this;
        }

        public Builder addMaxIndexDocsCondition(Long numDocs) {
            if (numDocs != null) {
                MaxDocsCondition maxDocsCondition = new MaxDocsCondition(numDocs);
                this.conditions.put(maxDocsCondition.name, maxDocsCondition);
            }
            return this;
        }

        public Builder addMaxIndexSizeCondition(ByteSizeValue size) {
            if (size != null) {
                MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
                this.conditions.put(maxSizeCondition.name, maxSizeCondition);
            }
            return this;
        }

        public Builder addMaxPrimaryShardSizeCondition(ByteSizeValue size) {
            if (size != null) {
                MaxPrimaryShardSizeCondition maxPrimaryShardSizeCondition = new MaxPrimaryShardSizeCondition(size);
                this.conditions.put(maxPrimaryShardSizeCondition.name, maxPrimaryShardSizeCondition);
            }
            return this;
        }

        public Builder addMaxPrimaryShardDocsCondition(Long numDocs) {
            if (numDocs != null) {
                MaxPrimaryShardDocsCondition maxPrimaryShardDocsCondition = new MaxPrimaryShardDocsCondition(numDocs);
                this.conditions.put(maxPrimaryShardDocsCondition.name, maxPrimaryShardDocsCondition);
            }
            return this;
        }

        public Builder addMinIndexAgeCondition(TimeValue age) {
            if (age != null) {
                MinAgeCondition minAgeCondition = new MinAgeCondition(age);
                this.conditions.put(minAgeCondition.name, minAgeCondition);
            }
            return this;
        }

        public Builder addMinIndexDocsCondition(Long numDocs) {
            if (numDocs != null) {
                MinDocsCondition minDocsCondition = new MinDocsCondition(numDocs);
                this.conditions.put(minDocsCondition.name, minDocsCondition);
            }
            return this;
        }

        public Builder addMinIndexSizeCondition(ByteSizeValue size) {
            if (size != null) {
                MinSizeCondition minSizeCondition = new MinSizeCondition(size);
                this.conditions.put(minSizeCondition.name, minSizeCondition);
            }
            return this;
        }

        public Builder addMinPrimaryShardSizeCondition(ByteSizeValue size) {
            if (size != null) {
                MinPrimaryShardSizeCondition minPrimaryShardSizeCondition = new MinPrimaryShardSizeCondition(size);
                this.conditions.put(minPrimaryShardSizeCondition.name, minPrimaryShardSizeCondition);
            }
            return this;
        }

        public Builder addMinPrimaryShardDocsCondition(Long numDocs) {
            if (numDocs != null) {
                MinPrimaryShardDocsCondition minPrimaryShardDocsCondition = new MinPrimaryShardDocsCondition(numDocs);
                this.conditions.put(minPrimaryShardDocsCondition.name, minPrimaryShardDocsCondition);
            }
            return this;
        }

        public RolloverConditions build() {
            return new RolloverConditions(this.conditions);
        }
    }
}

