/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NodesStatsRequestParameters
implements Writeable {
    private CommonStatsFlags indices = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
    private final Set<String> requestedMetrics = new HashSet<String>();
    private boolean includeShardsStats = true;

    public NodesStatsRequestParameters() {
    }

    public NodesStatsRequestParameters(StreamInput in) throws IOException {
        this.indices = new CommonStatsFlags(in);
        this.requestedMetrics.clear();
        this.requestedMetrics.addAll(in.readStringCollectionAsList());
        this.includeShardsStats = in.getTransportVersion().onOrAfter(TransportVersions.INCLUDE_SHARDS_STATS_ADDED) ? in.readBoolean() : true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.indices.writeTo(out);
        out.writeStringCollection(this.requestedMetrics);
        if (out.getTransportVersion().onOrAfter(TransportVersions.INCLUDE_SHARDS_STATS_ADDED)) {
            out.writeBoolean(this.includeShardsStats);
        }
    }

    public CommonStatsFlags indices() {
        return this.indices;
    }

    public void setIndices(CommonStatsFlags indices) {
        this.indices = indices;
    }

    public Set<String> requestedMetrics() {
        return this.requestedMetrics;
    }

    public boolean includeShardsStats() {
        return this.includeShardsStats;
    }

    public void setIncludeShardsStats(boolean includeShardsStats) {
        this.includeShardsStats = includeShardsStats;
    }

    public static enum Metric {
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        FS("fs"),
        TRANSPORT("transport"),
        HTTP("http"),
        BREAKER("breaker"),
        SCRIPT("script"),
        DISCOVERY("discovery"),
        INGEST("ingest"),
        ADAPTIVE_SELECTION("adaptive_selection"),
        SCRIPT_CACHE("script_cache"),
        INDEXING_PRESSURE("indexing_pressure"),
        REPOSITORIES("repositories");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }
    }
}

