/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalMasterServiceTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterHealthAction.class);
    private final AllocationService allocationService;

    @Inject
    public TransportClusterHealthAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService) {
        super("cluster:monitor/health", false, transportService, clusterService, threadPool, actionFilters, ClusterHealthRequest::new, indexNameExpressionResolver, ClusterHealthResponse::new, threadPool.executor("management"));
        this.allocationService = allocationService;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(Task task, ClusterHealthRequest request, ClusterState unusedState, ActionListener<ClusterHealthResponse> listener) {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        int waitCount = TransportClusterHealthAction.getWaitCount(request);
        if (request.waitForEvents() != null) {
            this.waitForEventsAndExecuteHealth(cancellableTask, request, listener, waitCount, this.threadPool.relativeTimeInMillis() + request.timeout().millis());
        } else {
            this.executeHealth(cancellableTask, request, this.clusterService.state(), listener, waitCount, clusterState -> this.sendResponse(cancellableTask, request, (ClusterState)clusterState, waitCount, TimeoutState.OK, listener));
        }
    }

    private void waitForEventsAndExecuteHealth(final CancellableTask task, final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final long endTimeRelativeMillis) {
        if (task.notifyIfCancelled(listener)) {
            return;
        }
        assert (request.waitForEvents() != null);
        final String source = "cluster_health (wait_for_events [" + request.waitForEvents() + "])";
        if (request.local()) {
            new LocalMasterServiceTask(request.waitForEvents()){

                @Override
                protected void onPublicationComplete() {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executor.execute(() -> TransportClusterHealthAction.this.executeHealth(task, request, TransportClusterHealthAction.this.clusterService.state(), listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(task, request, listener, waitCount, endTimeRelativeMillis)));
                }

                @Override
                public void onFailure(Exception e) {
                    logger.error(() -> "unexpected failure during [" + source + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            }.submit(this.clusterService.getMasterService(), source);
        } else {
            TimeValue taskTimeout = TimeValue.timeValueMillis((long)Math.max(0L, endTimeRelativeMillis - this.threadPool.relativeTimeInMillis()));
            this.submitUnbatchedTask(source, new ClusterStateUpdateTask(request.waitForEvents(), taskTimeout){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    ClusterState appliedState = TransportClusterHealthAction.this.clusterService.state();
                    assert (newState.stateUUID().equals(appliedState.stateUUID())) : newState.stateUUID() + " vs " + appliedState.stateUUID();
                    TransportClusterHealthAction.this.executor.execute(() -> TransportClusterHealthAction.this.executeHealth(task, request, appliedState, listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(task, request, listener, waitCount, endTimeRelativeMillis)));
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof ProcessClusterEventTimeoutException) {
                        TransportClusterHealthAction.this.executor.execute(() -> TransportClusterHealthAction.this.sendResponse(task, request, TransportClusterHealthAction.this.clusterService.state(), waitCount, TimeoutState.TIMED_OUT, listener));
                    } else {
                        Level level = 2.isExpectedFailure(e) ? Level.TRACE : Level.ERROR;
                        logger.log(level, () -> "unexpected failure during [" + source + "]", (Throwable)e);
                        assert (2.isExpectedFailure(e)) : e;
                        listener.onFailure(e);
                    }
                }

                static boolean isExpectedFailure(Exception e) {
                    EsRejectedExecutionException esre;
                    Throwable throwable;
                    return e instanceof NotMasterException || e instanceof FailedToCommitClusterStateException && (throwable = e.getCause()) instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)throwable).isExecutorShutdown();
                }
            });
        }
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private void executeHealth(final CancellableTask task, final ClusterHealthRequest request, ClusterState currentState, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final Consumer<ClusterState> onNewClusterStateAfterDelay) {
        if (task.notifyIfCancelled(listener)) {
            return;
        }
        if (request.timeout().millis() == 0L) {
            this.sendResponse(task, request, currentState, waitCount, TimeoutState.ZERO_TIMEOUT, listener);
            return;
        }
        Predicate<ClusterState> validationPredicate = newState -> this.validateRequest(request, (ClusterState)newState, waitCount);
        if (validationPredicate.test(currentState)) {
            this.sendResponse(task, request, currentState, waitCount, TimeoutState.OK, listener);
        } else {
            final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
            ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    TransportClusterHealthAction.this.executor.execute(() -> onNewClusterStateAfterDelay.accept(newState));
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterHealthAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    TransportClusterHealthAction.this.executor.execute(() -> TransportClusterHealthAction.this.sendResponse(task, request, observer.setAndGetObservedState(), waitCount, TimeoutState.TIMED_OUT, listener));
                }
            };
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private static int getWaitCount(ClusterHealthRequest request) {
        int waitCount = 0;
        if (request.waitForStatus() != null) {
            ++waitCount;
        }
        if (request.waitForNoRelocatingShards()) {
            ++waitCount;
        }
        if (request.waitForNoInitializingShards()) {
            ++waitCount;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ++waitCount;
        }
        if (!request.waitForNodes().isEmpty()) {
            ++waitCount;
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            ++waitCount;
        }
        return waitCount;
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitCount) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getMasterService().getMaxTaskWaitTime());
        return TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver) == waitCount;
    }

    private void sendResponse(CancellableTask task, ClusterHealthRequest request, ClusterState clusterState, int waitFor, TimeoutState timeoutState, ActionListener<ClusterHealthResponse> listener) {
        assert (ThreadPool.assertCurrentThreadPool("management"));
        ActionListener.completeWith(listener, () -> {
            boolean valid;
            task.ensureNotCancelled();
            ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getMasterService().getMaxTaskWaitTime());
            int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
            boolean bl = valid = readyCounter == waitFor;
            assert (valid || timeoutState != TimeoutState.OK);
            response.setTimedOut(!valid || timeoutState == TimeoutState.TIMED_OUT);
            return response;
        });
    }

    static int prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForNoRelocatingShards() && response.getRelocatingShards() == 0) {
            ++waitForCounter;
        }
        if (request.waitForNoInitializingShards() && response.getInitializingShards() == 0) {
            ++waitForCounter;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ActiveShardCount waitForActiveShards = request.waitForActiveShards();
            assert (!waitForActiveShards.equals(ActiveShardCount.DEFAULT)) : "waitForActiveShards must not be DEFAULT on the request object, instead it should be NONE";
            if (waitForActiveShards.equals(ActiveShardCount.ALL)) {
                if (response.getUnassignedShards() == 0 && response.getInitializingShards() == 0) {
                    ++waitForCounter;
                }
            } else if (waitForActiveShards.enoughShardsActive(response.getActiveShards())) {
                ++waitForCounter;
            }
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            try {
                indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.strictExpand(), request);
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (logger.isTraceEnabled()) {
            logger.trace("Calculating health based on state version [{}]", (Object)clusterState.version());
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(clusterState.getClusterName().value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(clusterState.getClusterName().value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
    }

    private static enum TimeoutState {
        OK,
        TIMED_OUT,
        ZERO_TIMEOUT;

    }
}

