/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class Version
implements VersionId<Version>,
ToXContentFragment {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0);
    public static final Version V_7_0_0 = new Version(7000099);
    public static final Version V_7_0_1 = new Version(7000199);
    public static final Version V_7_1_0 = new Version(7010099);
    public static final Version V_7_1_1 = new Version(7010199);
    public static final Version V_7_2_0 = new Version(7020099);
    public static final Version V_7_2_1 = new Version(7020199);
    public static final Version V_7_3_0 = new Version(7030099);
    public static final Version V_7_3_1 = new Version(7030199);
    public static final Version V_7_3_2 = new Version(7030299);
    public static final Version V_7_4_0 = new Version(7040099);
    public static final Version V_7_4_1 = new Version(7040199);
    public static final Version V_7_4_2 = new Version(7040299);
    public static final Version V_7_5_0 = new Version(7050099);
    public static final Version V_7_5_1 = new Version(7050199);
    public static final Version V_7_5_2 = new Version(7050299);
    public static final Version V_7_6_0 = new Version(7060099);
    public static final Version V_7_6_1 = new Version(7060199);
    public static final Version V_7_6_2 = new Version(0x6BBB4B);
    public static final Version V_7_7_0 = new Version(7070099);
    public static final Version V_7_7_1 = new Version(7070199);
    public static final Version V_7_8_0 = new Version(7080099);
    public static final Version V_7_8_1 = new Version(7080199);
    public static final Version V_7_9_0 = new Version(7090099);
    public static final Version V_7_9_1 = new Version(7090199);
    public static final Version V_7_9_2 = new Version(7090299);
    public static final Version V_7_9_3 = new Version(7090399);
    public static final Version V_7_10_0 = new Version(7100099);
    public static final Version V_7_10_1 = new Version(7100199);
    public static final Version V_7_10_2 = new Version(7100299);
    public static final Version V_7_11_0 = new Version(7110099);
    public static final Version V_7_11_1 = new Version(7110199);
    public static final Version V_7_11_2 = new Version(7110299);
    public static final Version V_7_12_0 = new Version(7120099);
    public static final Version V_7_12_1 = new Version(7120199);
    public static final Version V_7_13_0 = new Version(7130099);
    public static final Version V_7_13_1 = new Version(7130199);
    public static final Version V_7_13_2 = new Version(0x6CCCBB);
    public static final Version V_7_13_3 = new Version(7130399);
    public static final Version V_7_13_4 = new Version(7130499);
    public static final Version V_7_14_0 = new Version(7140099);
    public static final Version V_7_14_1 = new Version(7140199);
    public static final Version V_7_14_2 = new Version(7140299);
    public static final Version V_7_15_0 = new Version(7150099);
    public static final Version V_7_15_1 = new Version(7150199);
    public static final Version V_7_15_2 = new Version(7150299);
    public static final Version V_7_16_0 = new Version(7160099);
    public static final Version V_7_16_1 = new Version(7160199);
    public static final Version V_7_16_2 = new Version(7160299);
    public static final Version V_7_16_3 = new Version(7160399);
    public static final Version V_7_17_0 = new Version(7170099);
    public static final Version V_7_17_1 = new Version(7170199);
    public static final Version V_7_17_2 = new Version(7170299);
    public static final Version V_7_17_3 = new Version(7170399);
    public static final Version V_7_17_4 = new Version(7170499);
    public static final Version V_7_17_5 = new Version(7170599);
    public static final Version V_7_17_6 = new Version(7170699);
    public static final Version V_7_17_7 = new Version(7170799);
    public static final Version V_7_17_8 = new Version(7170899);
    public static final Version V_7_17_9 = new Version(7170999);
    public static final Version V_7_17_10 = new Version(7171099);
    public static final Version V_7_17_11 = new Version(7171199);
    public static final Version V_7_17_12 = new Version(7171299);
    public static final Version V_7_17_13 = new Version(7171399);
    public static final Version V_7_17_14 = new Version(7171499);
    public static final Version V_7_17_15 = new Version(7171599);
    public static final Version V_7_17_16 = new Version(7171699);
    public static final Version V_7_17_17 = new Version(7171799);
    public static final Version V_7_17_18 = new Version(7171899);
    public static final Version V_7_17_19 = new Version(7171999);
    public static final Version V_8_0_0 = new Version(8000099);
    public static final Version V_8_0_1 = new Version(8000199);
    public static final Version V_8_1_0 = new Version(8010099);
    public static final Version V_8_1_1 = new Version(8010199);
    public static final Version V_8_1_2 = new Version(8010299);
    public static final Version V_8_1_3 = new Version(8010399);
    public static final Version V_8_2_0 = new Version(8020099);
    public static final Version V_8_2_1 = new Version(8020199);
    public static final Version V_8_2_2 = new Version(8020299);
    public static final Version V_8_2_3 = new Version(8020399);
    public static final Version V_8_3_0 = new Version(8030099);
    public static final Version V_8_3_1 = new Version(8030199);
    public static final Version V_8_3_2 = new Version(8030299);
    public static final Version V_8_3_3 = new Version(8030399);
    public static final Version V_8_4_0 = new Version(8040099);
    public static final Version V_8_4_1 = new Version(8040199);
    public static final Version V_8_4_2 = new Version(8040299);
    public static final Version V_8_4_3 = new Version(8040399);
    public static final Version V_8_5_0 = new Version(8050099);
    public static final Version V_8_5_1 = new Version(8050199);
    public static final Version V_8_5_2 = new Version(8050299);
    public static final Version V_8_5_3 = new Version(8050399);
    public static final Version V_8_6_0 = new Version(8060099);
    public static final Version V_8_6_1 = new Version(8060199);
    public static final Version V_8_6_2 = new Version(8060299);
    public static final Version V_8_7_0 = new Version(8070099);
    public static final Version V_8_7_1 = new Version(8070199);
    public static final Version V_8_8_0 = new Version(8080099);
    public static final Version V_8_8_1 = new Version(0x7B4B47);
    public static final Version V_8_8_2 = new Version(8080299);
    public static final Version V_8_9_0 = new Version(8090099);
    public static final Version V_8_9_1 = new Version(8090199);
    public static final Version V_8_9_2 = new Version(0x7B72BB);
    public static final Version V_8_10_0 = new Version(8100099);
    public static final Version V_8_10_1 = new Version(8100199);
    public static final Version V_8_10_2 = new Version(8100299);
    public static final Version V_8_10_3 = new Version(8100399);
    public static final Version V_8_10_4 = new Version(8100499);
    public static final Version V_8_11_0 = new Version(8110099);
    public static final Version V_8_11_1 = new Version(8110199);
    public static final Version V_8_11_2 = new Version(8110299);
    public static final Version V_8_11_3 = new Version(8110399);
    public static final Version V_8_11_4 = new Version(8110499);
    public static final Version V_8_12_0 = new Version(8120099);
    public static final Version V_8_12_1 = new Version(8120199);
    public static final Version V_8_12_2;
    public static final Version CURRENT;
    private static final NavigableMap<Integer, Version> VERSION_IDS;
    private static final Map<String, Version> VERSION_STRINGS;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    private final String toString;
    private final int previousMajorId;
    private Version minCompatVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        Version known = (Version)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    private static Version fromIdSlow(int id) {
        return new Version(id);
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        Version cached = VERSION_STRINGS.get(version);
        if (cached != null) {
            return cached;
        }
        return Version.fromStringSlow(version);
    }

    private static Version fromStringSlow(String version) {
        String[] parts;
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length != 3) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            if (parts[1].length() > 2) {
                throw new IllegalArgumentException("illegal minor version format - only one or two digit numbers are supported but found " + parts[1]);
            }
            if (parts[2].length() > 2) {
                throw new IllegalArgumentException("illegal revision version format - only one or two digit numbers are supported but found " + parts[2]);
            }
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            return Version.fromId(major + minor + revision + 99);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.toString = this.major + "." + this.minor + "." + this.revision;
        this.previousMajorId = this.major > 0 ? (this.major - 1) * 1000000 + 99 : this.major;
    }

    @Override
    public int id() {
        return this.id;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        Version res = this.minCompatVersion;
        if (res == null) {
            this.minCompatVersion = res = this.computeMinCompatVersion();
        }
        return res;
    }

    private Version computeMinCompatVersion() {
        if (this.major == 6) {
            return Version.fromId(5060099);
        }
        if (this.major == 7) {
            return Version.fromId(6080099);
        }
        if (this.major >= 8) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.major * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    public Version previousMajor() {
        return Version.fromId(this.previousMajorId);
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s, JVM: %s", Build.current().qualifiedVersion(), Build.current().type().displayName(), Build.current().hash(), Build.current().date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+){3}?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_8_12_2 = new Version(0x7BE7EB);
        TreeMap<Integer, Version> builder = new TreeMap<Integer, Version>();
        HashMap<String, Version> builderByString = new HashMap<String, Version>();
        for (Field declaredField : Version.class.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(Version.class) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED) {
                    String[] fields = fieldName.split("_");
                    int major = Integer.valueOf(fields[1]) * 1000000;
                    int minor = Integer.valueOf(fields[2]) * 10000;
                    int revision = Integer.valueOf(fields[3]) * 100;
                    int expectedId = major + minor + revision + 99;
                    assert (version.id == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.id + "]";
                }
                Version maybePrevious = builder.put(version.id, version);
                builderByString.put(version.toString(), version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.id + "] to be uniquely mapped but saw [" + maybePrevious + "] and [" + version + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
        }
        assert (RestApiVersion.current().major == Version.CURRENT.major && RestApiVersion.previous().major == Version.CURRENT.major - 1) : "RestApiVersion must be upgraded to reflect major from Version.CURRENT [" + Version.CURRENT.major + "] but is still set to [" + RestApiVersion.current().major + "]";
        builder.put(0, V_EMPTY);
        builderByString.put(V_EMPTY.toString(), V_EMPTY);
        VERSION_IDS = Collections.unmodifiableNavigableMap(builder);
        VERSION_STRINGS = Map.copyOf(builderByString);
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = List.copyOf(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

