/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class ResultBuilderForDouble
implements ResultBuilder {
    private final DoubleBlock.Builder builder;
    private final boolean inKey;
    private double key;

    ResultBuilderForDouble(BlockFactory blockFactory, TopNEncoder encoder, boolean inKey, int initialSize) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
        this.builder = DoubleBlock.newBlockBuilder(initialSize, blockFactory);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        assert (this.inKey);
        this.key = TopNEncoder.DEFAULT_SORTABLE.decodeDouble(keys);
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        switch (count) {
            case 0: {
                this.builder.appendNull();
                break;
            }
            case 1: {
                this.builder.appendDouble(this.inKey ? this.key : this.readValueFromValues(values));
                break;
            }
            default: {
                this.builder.beginPositionEntry();
                for (int i = 0; i < count; ++i) {
                    this.builder.appendDouble(this.readValueFromValues(values));
                }
                this.builder.endPositionEntry();
            }
        }
    }

    private double readValueFromValues(BytesRef values) {
        return TopNEncoder.DEFAULT_UNSORTABLE.decodeDouble(values);
    }

    @Override
    public DoubleBlock build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForDouble[inKey=" + this.inKey + "]";
    }

    public void close() {
        this.builder.close();
    }
}

