/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.KeyExtractor;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

abstract class KeyExtractorForDouble
implements KeyExtractor {
    private final byte nul;
    private final byte nonNul;

    static KeyExtractorForDouble extractorFor(TopNEncoder encoder, boolean ascending, byte nul, byte nonNul, DoubleBlock block) {
        DoubleVector v = block.asVector();
        if (v != null) {
            return new ForVector(encoder, nul, nonNul, v);
        }
        if (ascending) {
            return block.mvSortedAscending() ? new MinForAscending(encoder, nul, nonNul, block) : new MinForUnordered(encoder, nul, nonNul, block);
        }
        return block.mvSortedAscending() ? new MaxForAscending(encoder, nul, nonNul, block) : new MaxForUnordered(encoder, nul, nonNul, block);
    }

    KeyExtractorForDouble(TopNEncoder encoder, byte nul, byte nonNul) {
        assert (encoder == TopNEncoder.DEFAULT_SORTABLE);
        this.nul = nul;
        this.nonNul = nonNul;
    }

    protected final int nonNul(BreakingBytesRefBuilder key, double value) {
        key.append(this.nonNul);
        TopNEncoder.DEFAULT_SORTABLE.encodeDouble(value, key);
        return 9;
    }

    protected final int nul(BreakingBytesRefBuilder key) {
        key.append(this.nul);
        return 1;
    }

    static class ForVector
    extends KeyExtractorForDouble {
        private final DoubleVector vector;

        ForVector(TopNEncoder encoder, byte nul, byte nonNul, DoubleVector vector) {
            super(encoder, nul, nonNul);
            this.vector = vector;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            return this.nonNul(key, this.vector.getDouble(position));
        }
    }

    static class MinForAscending
    extends KeyExtractorForDouble {
        private final DoubleBlock block;

        MinForAscending(TopNEncoder encoder, byte nul, byte nonNul, DoubleBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getDouble(this.block.getFirstValueIndex(position)));
        }
    }

    static class MinForUnordered
    extends KeyExtractorForDouble {
        private final DoubleBlock block;

        MinForUnordered(TopNEncoder encoder, byte nul, byte nonNul, DoubleBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            double min = this.block.getDouble(start);
            for (int i = start + 1; i < end; ++i) {
                min = Math.min(min, this.block.getDouble(i));
            }
            return this.nonNul(key, min);
        }
    }

    static class MaxForAscending
    extends KeyExtractorForDouble {
        private final DoubleBlock block;

        MaxForAscending(TopNEncoder encoder, byte nul, byte nonNul, DoubleBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getDouble(this.block.getFirstValueIndex(position) + this.block.getValueCount(position) - 1));
        }
    }

    static class MaxForUnordered
    extends KeyExtractorForDouble {
        private final DoubleBlock block;

        MaxForUnordered(TopNEncoder encoder, byte nul, byte nonNul, DoubleBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            double max = this.block.getDouble(start);
            for (int i = start + 1; i < end; ++i) {
                max = Math.max(max, this.block.getDouble(i));
            }
            return this.nonNul(key, max);
        }
    }
}

