/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;

public class ProjectOperator
extends AbstractPageMappingOperator {
    private final Set<Integer> pagesUsed;
    private final int[] projection;
    private Block[] blocks;

    public ProjectOperator(List<Integer> projection) {
        this.pagesUsed = new HashSet<Integer>(projection);
        this.projection = projection.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    protected Page process(Page page) {
        int blockCount = page.getBlockCount();
        if (blockCount == 0) {
            return page;
        }
        if (this.blocks == null) {
            this.blocks = new Block[this.projection.length];
        }
        Arrays.fill(this.blocks, null);
        int b = 0;
        for (int source : this.projection) {
            if (source >= blockCount) {
                throw new IllegalArgumentException("Cannot project block with index [" + source + "] from a page with size [" + blockCount + "]");
            }
            Object block = page.getBlock(source);
            this.blocks[b++] = block;
            block.incRef();
        }
        int positionCount = page.getPositionCount();
        page.releaseBlocks();
        return new Page(positionCount, this.blocks);
    }

    @Override
    public String toString() {
        return "ProjectOperator[projection = " + Arrays.toString(this.projection) + "]";
    }

    static void assertNotReleasing(List<Releasable> toRelease, Block toKeep) {
        assert (!toRelease.stream().anyMatch(r -> r == toKeep)) : "both releasing and keeping the same block: " + toRelease.stream().filter(r -> r == toKeep).toList();
    }

    public record ProjectOperatorFactory(List<Integer> projection) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ProjectOperator(this.projection);
        }

        @Override
        public String describe() {
            return "ProjectOperator[projection = " + this.projection + "]";
        }
    }
}

