/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.OwningChannelActionListener;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverRunner;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class DriverTaskRunner {
    public static final String ACTION_NAME = "indices:data/read/esql/compute";
    private final TransportService transportService;

    public DriverTaskRunner(TransportService transportService, Executor executor) {
        this.transportService = transportService;
        transportService.registerRequestHandler(ACTION_NAME, executor, DriverRequest::new, (TransportRequestHandler)new DriverRequestHandler(transportService));
    }

    public void executeDrivers(final Task parentTask, List<Driver> drivers, final Executor executor, ActionListener<Void> listener) {
        DriverRunner runner = new DriverRunner(this.transportService.getThreadPool().getThreadContext()){

            @Override
            protected void start(Driver driver, ActionListener<Void> driverListener) {
                DriverTaskRunner.this.transportService.sendChildRequest(DriverTaskRunner.this.transportService.getLocalNode(), DriverTaskRunner.ACTION_NAME, (TransportRequest)new DriverRequest(driver, executor), parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)TransportResponseHandler.empty((Executor)executor, (ActionListener)ActionListener.wrap(arg_0 -> driverListener.onResponse(arg_0), e -> driver.abort((Exception)e, driverListener))));
            }
        };
        runner.runToCompletion(drivers, listener);
    }

    private record DriverRequestHandler(TransportService transportService) implements TransportRequestHandler<DriverRequest>
    {
        public void messageReceived(DriverRequest request, TransportChannel channel, Task task) {
            OwningChannelActionListener listener = new OwningChannelActionListener(channel);
            Driver.start(this.transportService.getThreadPool().getThreadContext(), request.executor, request.driver, 10000, (ActionListener<Void>)listener.map(unused -> TransportResponse.Empty.INSTANCE));
        }
    }

    private static class DriverRequest
    extends ActionRequest
    implements CompositeIndicesRequest {
        private final Driver driver;
        private final Executor executor;

        DriverRequest(Driver driver, Executor executor) {
            this.driver = driver;
            this.executor = executor;
        }

        DriverRequest(StreamInput in) {
            throw new UnsupportedOperationException("Driver request should never leave the current node");
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Driver request should never leave the current node");
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            if (!parentTaskId.isSet()) {
                assert (false) : "DriverRequest must have a parent task";
                throw new IllegalStateException("DriverRequest must have a parent task");
            }
            return new CancellableTask(id, type, action, "", parentTaskId, headers){

                protected void onCancelled() {
                    String reason = Objects.requireNonNullElse(this.getReasonCancelled(), "cancelled");
                    driver.cancel(reason);
                }

                public String getDescription() {
                    return driver.describe();
                }

                public Task.Status getStatus() {
                    return driver.status();
                }
            };
        }
    }
}

