/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBlock;
import org.elasticsearch.core.Releasable;

public final class IntBigArrayVector
extends AbstractVector
implements IntVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntBigArrayVector.class);
    private final IntArray values;
    private final IntBlock block;

    public IntBigArrayVector(IntArray values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public IntBigArrayVector(IntArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new IntVectorBlock(this);
    }

    @Override
    public IntBlock asBlock() {
        return this.block;
    }

    @Override
    public int getInt(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public IntVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        IntArray filtered = blockFactory.bigArrays().newIntArray((long)positions.length, true);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new IntBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntVector) {
            IntVector that = (IntVector)obj;
            return IntVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

