/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.DoubleVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;

public final class DoubleBigArrayVector
extends AbstractVector
implements DoubleVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DoubleBigArrayVector.class);
    private final DoubleArray values;
    private final DoubleBlock block;

    public DoubleBigArrayVector(DoubleArray values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public DoubleBigArrayVector(DoubleArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new DoubleVectorBlock(this);
    }

    @Override
    public DoubleBlock asBlock() {
        return this.block;
    }

    @Override
    public double getDouble(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOUBLE;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public DoubleVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        DoubleArray filtered = blockFactory.bigArrays().newDoubleArray((long)positions.length, true);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new DoubleBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleVector) {
            DoubleVector that = (DoubleVector)obj;
            return DoubleVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

