/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBlock;
import org.elasticsearch.compute.data.ElementType;

public final class ConstantBytesRefVector
extends AbstractVector
implements BytesRefVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantBytesRefVector.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private final BytesRef value;
    private final BytesRefBlock block;

    public ConstantBytesRefVector(BytesRef value, int positionCount) {
        this(value, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public ConstantBytesRefVector(BytesRef value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
        this.block = new BytesRefVectorBlock(this);
    }

    @Override
    public BytesRef getBytesRef(int position, BytesRef ignore) {
        return this.value;
    }

    @Override
    public BytesRefBlock asBlock() {
        return this.block;
    }

    @Override
    public BytesRefVector filter(int ... positions) {
        return new ConstantBytesRefVector(this.value, positions.length);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public static long ramBytesUsed(BytesRef value) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((byte[])value.bytes);
    }

    public long ramBytesUsed() {
        return ConstantBytesRefVector.ramBytesUsed(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefVector) {
            BytesRefVector that = (BytesRefVector)obj;
            return BytesRefVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.blockFactory().adjustBreaker(-this.ramBytesUsed(), true);
    }
}

