/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.BitSet;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Nullable;

abstract class AbstractBlock
implements Block {
    private int references = 1;
    private final int positionCount;
    @Nullable
    protected final int[] firstValueIndexes;
    @Nullable
    protected final BitSet nullsMask;
    private BlockFactory blockFactory;

    protected AbstractBlock(int positionCount, BlockFactory blockFactory) {
        assert (positionCount >= 0);
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
        this.firstValueIndexes = null;
        this.nullsMask = null;
    }

    protected AbstractBlock(int positionCount, @Nullable int[] firstValueIndexes, @Nullable BitSet nullsMask, BlockFactory blockFactory) {
        assert (positionCount >= 0);
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
        this.firstValueIndexes = firstValueIndexes;
        BitSet bitSet = this.nullsMask = nullsMask == null || nullsMask.isEmpty() ? null : nullsMask;
        assert (nullsMask != null || firstValueIndexes != null) : "Create VectorBlock instead";
    }

    @Override
    public int getTotalValueCount() {
        if (this.firstValueIndexes == null) {
            return this.positionCount - this.nullValuesCount();
        }
        return this.firstValueIndexes[this.positionCount] - this.nullValuesCount();
    }

    @Override
    public final int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        return this.firstValueIndexes == null ? position : this.firstValueIndexes[position];
    }

    @Override
    public int getValueCount(int position) {
        return this.isNull(position) ? 0 : (this.firstValueIndexes == null ? 1 : this.firstValueIndexes[position + 1] - this.firstValueIndexes[position]);
    }

    @Override
    public boolean isNull(int position) {
        return this.mayHaveNulls() && this.nullsMask.get(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.nullsMask != null;
    }

    @Override
    public int nullValuesCount() {
        return this.mayHaveNulls() ? this.nullsMask.cardinality() : 0;
    }

    @Override
    public boolean areAllValuesNull() {
        return this.nullValuesCount() == this.getPositionCount();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.blockFactory = this.blockFactory.parent();
    }

    @Override
    public boolean isReleased() {
        return !this.hasReferences();
    }

    public final void incRef() {
        if (this.isReleased()) {
            throw new IllegalStateException("can't increase refCount on already released block [" + this + "]");
        }
        ++this.references;
    }

    public final boolean tryIncRef() {
        if (this.isReleased()) {
            return false;
        }
        ++this.references;
        return true;
    }

    public final boolean decRef() {
        if (this.isReleased()) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        --this.references;
        if (this.references <= 0) {
            this.closeInternal();
            return true;
        }
        return false;
    }

    public final boolean hasReferences() {
        return this.references >= 1;
    }

    public final void close() {
        this.decRef();
    }

    protected abstract void closeInternal();
}

