/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MedianAbsoluteDeviationIntAggregator;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MedianAbsoluteDeviationIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("quart", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final QuantileStates.SingleState state;
    private final List<Integer> channels;

    public MedianAbsoluteDeviationIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, QuantileStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MedianAbsoluteDeviationIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MedianAbsoluteDeviationIntAggregatorFunction(driverContext, channels, MedianAbsoluteDeviationIntAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        IntBlock block = (IntBlock)page.getBlock(this.channels.get(0));
        IntVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(IntVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            MedianAbsoluteDeviationIntAggregator.combine(this.state, vector.getInt(i));
        }
    }

    private void addRawBlock(IntBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                MedianAbsoluteDeviationIntAggregator.combine(this.state, block.getInt(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MedianAbsoluteDeviationIntAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        BytesRefVector quart = ((BytesRefBlock)page.getBlock(this.channels.get(0))).asVector();
        assert (quart.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        MedianAbsoluteDeviationIntAggregator.combineIntermediate(this.state, quart.getBytesRef(0, scratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = MedianAbsoluteDeviationIntAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

