/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class IntArrayState
extends AbstractArrayState
implements GroupingAggregatorState {
    private final int init;
    private IntArray values;

    IntArrayState(BigArrays bigArrays, int init) {
        super(bigArrays);
        this.values = bigArrays.newIntArray(1L, false);
        this.values.set(0L, init);
        this.init = init;
    }

    int get(int groupId) {
        return this.values.get((long)groupId);
    }

    int getOrDefault(int groupId) {
        return (long)groupId < this.values.size() ? this.values.get((long)groupId) : this.init;
    }

    void set(int groupId, int value) {
        this.ensureCapacity(groupId);
        this.values.set((long)groupId, value);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.trackingGroupIds()) {
            try (IntVector.Builder builder = IntVector.newVectorBuilder(selected.getPositionCount(), driverContext.blockFactory());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    builder.appendInt(this.values.get((long)selected.getInt(i)));
                }
                IntBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (IntBlock.Builder builder = IntBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    builder.appendInt(this.values.get((long)group));
                    continue;
                }
                builder.appendNull();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        if ((long)groupId >= this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.values.fill(prevSize, this.values.size(), this.init);
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        try (IntBlock.Builder valuesBuilder = IntBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());
             BooleanBlock.Builder hasValueBuilder = BooleanBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < this.values.size()) {
                    valuesBuilder.appendInt(this.values.get((long)group));
                } else {
                    valuesBuilder.appendInt(0);
                }
                hasValueBuilder.appendBoolean(this.hasValue(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }
}

