/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.CountDistinctBytesRefAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.HllStates;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctBytesRefGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("hll", ElementType.BYTES_REF));
    private final HllStates.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final BigArrays bigArrays;
    private final int precision;

    public CountDistinctBytesRefGroupingAggregatorFunction(List<Integer> channels, HllStates.GroupingState state, DriverContext driverContext, BigArrays bigArrays, int precision) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.bigArrays = bigArrays;
        this.precision = precision;
    }

    public static CountDistinctBytesRefGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, BigArrays bigArrays, int precision) {
        return new CountDistinctBytesRefGroupingAggregatorFunction(channels, CountDistinctBytesRefAggregator.initGrouping(bigArrays, precision), driverContext, bigArrays, precision);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        final BytesRefVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                CountDistinctBytesRefAggregator.combine(this.state, groupId, values.getBytesRef(v, scratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefVector values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            CountDistinctBytesRefAggregator.combine(this.state, groupId, values.getBytesRef(groupPosition + positionOffset, scratch));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    CountDistinctBytesRefAggregator.combine(this.state, groupId, values.getBytesRef(v, scratch));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, BytesRefVector values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                CountDistinctBytesRefAggregator.combine(this.state, groupId, values.getBytesRef(groupPosition + positionOffset, scratch));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        BytesRefVector hll = ((BytesRefBlock)page.getBlock(this.channels.get(0))).asVector();
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            CountDistinctBytesRefAggregator.combineIntermediate(this.state, groupId, hll.getBytesRef(groupPosition + positionOffset, scratch));
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + this.getClass() + "; got " + input.getClass());
        }
        HllStates.GroupingState inState = ((CountDistinctBytesRefGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        CountDistinctBytesRefAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = CountDistinctBytesRefAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

