/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.ListSearchApplicationAction;
import org.elasticsearch.xpack.core.action.util.PageParams;

public class TransportListSearchApplicationAction
extends HandledTransportAction<ListSearchApplicationAction.Request, ListSearchApplicationAction.Response> {
    protected final SearchApplicationIndexService systemIndexService;

    @Inject
    public TransportListSearchApplicationAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays) {
        super("cluster:admin/xpack/application/search_application/list", transportService, actionFilters, ListSearchApplicationAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new SearchApplicationIndexService(client, clusterService, namedWriteableRegistry, bigArrays);
    }

    protected void doExecute(Task task, ListSearchApplicationAction.Request request, ActionListener<ListSearchApplicationAction.Response> listener) {
        PageParams pageParams = request.pageParams();
        this.systemIndexService.listSearchApplication(request.query(), pageParams.getFrom(), pageParams.getSize(), (ActionListener<SearchApplicationIndexService.SearchApplicationResult>)listener.map(r -> new ListSearchApplicationAction.Response(r.items(), r.totalResults())));
    }
}

