/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SearchApplicationSearchRequest
extends ActionRequest
implements IndicesRequest,
ToXContentObject {
    private static final ParseField QUERY_PARAMS_FIELD = new ParseField("params", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private final String name;
    private final Map<String, Object> queryParams;
    private static final ConstructingObjectParser<SearchApplicationSearchRequest, String> PARSER = new ConstructingObjectParser("query_params", false, (params, searchAppName) -> {
        String name = Strings.isEmpty((CharSequence)searchAppName) ? (String)params[0] : searchAppName;
        Map queryParams = (Map)params[1];
        return new SearchApplicationSearchRequest(name, queryParams);
    });

    public SearchApplicationSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.queryParams = in.readMap();
    }

    public SearchApplicationSearchRequest(String name) {
        this(name, Map.of());
    }

    public SearchApplicationSearchRequest(String name, @Nullable Map<String, Object> queryParams) {
        this.name = Objects.requireNonNull(name, "Application name must be specified");
        this.queryParams = Objects.requireNonNullElse(queryParams, Map.of());
    }

    public static SearchApplicationSearchRequest fromXContent(String name, XContentParser contentParser) {
        return (SearchApplicationSearchRequest)((Object)PARSER.apply(contentParser, (Object)name));
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> queryParams() {
        return this.queryParams;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.name)) {
            validationException = ValidateActions.addValidationError((String)"Search Application name is missing", validationException);
        }
        return validationException;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeGenericMap(this.queryParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SearchApplicationSearchRequest request = (SearchApplicationSearchRequest)((Object)o);
        return Objects.equals(this.name, request.name) && Objects.equals(this.queryParams, request.queryParams);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.queryParams);
    }

    public String[] indices() {
        return new String[]{this.name};
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictNoExpandForbidClosed();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        if (!this.queryParams.isEmpty()) {
            builder.field(QUERY_PARAMS_FIELD.getPreferredName(), this.queryParams);
        }
        builder.endObject();
        return builder;
    }

    public static SearchApplicationSearchRequest parse(XContentParser parser) {
        return (SearchApplicationSearchRequest)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), QUERY_PARAMS_FIELD);
    }
}

