/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.QueryRule;

public class QueryRuleset
implements Writeable,
ToXContentObject {
    private final String id;
    private final List<QueryRule> rules;
    private static final ConstructingObjectParser<QueryRuleset, String> PARSER = new ConstructingObjectParser("query_ruleset", false, (params, resourceName) -> {
        String id = (String)params[0];
        if (id != null && !id.equals(resourceName)) {
            throw new IllegalArgumentException("Query ruleset identifier [" + id + "] does not match the resource name: [" + resourceName + "]");
        }
        List rules = (List)params[1];
        return new QueryRuleset((String)resourceName, rules);
    });
    public static final ParseField ID_FIELD = new ParseField("ruleset_id", new String[0]);
    public static final ParseField RULES_FIELD = new ParseField("rules", new String[0]);

    public QueryRuleset(String id, List<QueryRule> rules) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("id cannot be null or empty");
        }
        this.id = id;
        Objects.requireNonNull(rules, "rules cannot be null");
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("rules cannot be empty");
        }
        this.rules = rules;
    }

    public QueryRuleset(StreamInput in) throws IOException {
        this.id = in.readString();
        this.rules = in.readCollectionAsList(QueryRule::new);
    }

    public static QueryRuleset fromXContentBytes(String resourceName, BytesReference source, XContentType xContentType) {
        QueryRuleset queryRuleset;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                queryRuleset = QueryRuleset.fromXContent(resourceName, parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return queryRuleset;
    }

    public static QueryRuleset fromXContent(String resourceName, XContentParser parser) throws IOException {
        return (QueryRuleset)PARSER.parse(parser, (Object)resourceName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.xContentList(RULES_FIELD.getPreferredName(), this.rules);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeCollection(this.rules);
    }

    public String id() {
        return this.id;
    }

    public List<QueryRule> rules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRuleset that = (QueryRuleset)o;
        return this.id.equals(that.id) && Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rules);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ID_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRule.fromXContent(p), RULES_FIELD);
    }
}

