/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FilteringAdvancedSnippet
implements Writeable,
ToXContentObject {
    private final Instant advancedSnippetCreatedAt;
    private final Instant advancedSnippetUpdatedAt;
    private final Map<String, Object> advancedSnippetValue;
    private static final ParseField CREATED_AT_FIELD = new ParseField("created_at", new String[0]);
    private static final ParseField UPDATED_AT_FIELD = new ParseField("updated_at", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<FilteringAdvancedSnippet, Void> PARSER = new ConstructingObjectParser("connector_filtering_advanced_snippet", true, args -> new Builder().setAdvancedSnippetCreatedAt((Instant)args[0]).setAdvancedSnippetUpdatedAt((Instant)args[1]).setAdvancedSnippetValue((Map)args[2]).build());

    private FilteringAdvancedSnippet(Instant advancedSnippetCreatedAt, Instant advancedSnippetUpdatedAt, Map<String, Object> advancedSnippetValue) {
        this.advancedSnippetCreatedAt = advancedSnippetCreatedAt;
        this.advancedSnippetUpdatedAt = advancedSnippetUpdatedAt;
        this.advancedSnippetValue = advancedSnippetValue;
    }

    public FilteringAdvancedSnippet(StreamInput in) throws IOException {
        this.advancedSnippetCreatedAt = in.readInstant();
        this.advancedSnippetUpdatedAt = in.readInstant();
        this.advancedSnippetValue = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CREATED_AT_FIELD.getPreferredName(), (Object)this.advancedSnippetCreatedAt);
        builder.field(UPDATED_AT_FIELD.getPreferredName(), (Object)this.advancedSnippetUpdatedAt);
        builder.field(VALUE_FIELD.getPreferredName(), this.advancedSnippetValue);
        builder.endObject();
        return builder;
    }

    public static FilteringAdvancedSnippet fromXContent(XContentParser parser) throws IOException {
        return (FilteringAdvancedSnippet)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.advancedSnippetCreatedAt);
        out.writeInstant(this.advancedSnippetUpdatedAt);
        out.writeMap(this.advancedSnippetValue, StreamOutput::writeString, StreamOutput::writeGenericValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringAdvancedSnippet that = (FilteringAdvancedSnippet)o;
        return Objects.equals(this.advancedSnippetCreatedAt, that.advancedSnippetCreatedAt) && Objects.equals(this.advancedSnippetUpdatedAt, that.advancedSnippetUpdatedAt) && Objects.equals(this.advancedSnippetValue, that.advancedSnippetValue);
    }

    public int hashCode() {
        return Objects.hash(this.advancedSnippetCreatedAt, this.advancedSnippetUpdatedAt, this.advancedSnippetValue);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Instant.parse(p.text()), CREATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Instant.parse(p.text()), UPDATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), VALUE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    public static class Builder {
        private Instant advancedSnippetCreatedAt;
        private Instant advancedSnippetUpdatedAt;
        private Map<String, Object> advancedSnippetValue;

        public Builder setAdvancedSnippetCreatedAt(Instant advancedSnippetCreatedAt) {
            this.advancedSnippetCreatedAt = advancedSnippetCreatedAt;
            return this;
        }

        public Builder setAdvancedSnippetUpdatedAt(Instant advancedSnippetUpdatedAt) {
            this.advancedSnippetUpdatedAt = advancedSnippetUpdatedAt;
            return this;
        }

        public Builder setAdvancedSnippetValue(Map<String, Object> advancedSnippetValue) {
            this.advancedSnippetValue = advancedSnippetValue;
            return this;
        }

        public FilteringAdvancedSnippet build() {
            return new FilteringAdvancedSnippet(this.advancedSnippetCreatedAt, this.advancedSnippetUpdatedAt, this.advancedSnippetValue);
        }
    }
}

