/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.configuration;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class ConfigurationDependency
implements Writeable,
ToXContentObject {
    private final String field;
    private final Object value;
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<ConfigurationDependency, Void> PARSER = new ConstructingObjectParser("connector_configuration_dependency", true, args -> new Builder().setField((String)args[0]).setValue(args[1]).build());

    public ConfigurationDependency(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    public ConfigurationDependency(StreamInput in) throws IOException {
        this.field = in.readString();
        this.value = in.readGenericValue();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public static ConfigurationDependency fromXContent(XContentParser parser) throws IOException {
        return (ConfigurationDependency)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeGenericValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationDependency that = (ConfigurationDependency)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return Boolean.valueOf(p.booleanValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, VALUE_FIELD, ObjectParser.ValueType.VALUE);
    }

    public static class Builder {
        private String field;
        private Object value;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public ConfigurationDependency build() {
            return new ConfigurationDependency(this.field, this.value);
        }
    }
}

