/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorScheduling;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorSchedulingAction
extends ActionType<ConnectorUpdateActionResponse> {
    public static final UpdateConnectorSchedulingAction INSTANCE = new UpdateConnectorSchedulingAction();
    public static final String NAME = "cluster:admin/xpack/connector/update_scheduling";

    public UpdateConnectorSchedulingAction() {
        super(NAME, ConnectorUpdateActionResponse::new);
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final ConnectorScheduling scheduling;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_scheduling_request", false, (args, connectorId) -> new Request((String)connectorId, (ConnectorScheduling)args[0]));

        public Request(String connectorId, ConnectorScheduling scheduling) {
            this.connectorId = connectorId;
            this.scheduling = scheduling;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.scheduling = (ConnectorScheduling)in.readOptionalWriteable(ConnectorScheduling::new);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorScheduling getScheduling() {
            return this.scheduling;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be null or empty.", validationException);
            }
            if (Objects.isNull(this.scheduling)) {
                validationException = ValidateActions.addValidationError((String)"[scheduling] cannot be null.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContentBytes(String connectorId, BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser, connectorId);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.SCHEDULING_FIELD.getPreferredName(), (ToXContent)this.scheduling);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalWriteable((Writeable)this.scheduling);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.scheduling, request.scheduling);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.scheduling);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorScheduling.fromXContent(p), Connector.SCHEDULING_FIELD);
        }
    }
}

