/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.ConnectorIndexService;
import org.elasticsearch.xpack.application.connector.action.DeleteConnectorAction;

public class TransportDeleteConnectorAction
extends HandledTransportAction<DeleteConnectorAction.Request, AcknowledgedResponse> {
    protected final ConnectorIndexService connectorIndexService;

    @Inject
    public TransportDeleteConnectorAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/connector/delete", transportService, actionFilters, DeleteConnectorAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorIndexService = new ConnectorIndexService(client);
    }

    protected void doExecute(Task task, DeleteConnectorAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String connectorId = request.getConnectorId();
        this.connectorIndexService.deleteConnector(connectorId, (ActionListener<DeleteResponse>)listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

