/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorStatus;
import org.elasticsearch.xpack.application.connector.action.PostConnectorAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorConfigurationAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorErrorAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorFilteringAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorLastSeenAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorLastSyncStatsAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNameAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorPipelineAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorSchedulingAction;

public class ConnectorIndexService {
    private final Client clientWithOrigin;
    public static final String CONNECTOR_INDEX_NAME = ".elastic-connectors-v1";

    public ConnectorIndexService(Client client) {
        this.clientWithOrigin = new OriginSettingClient(client, "connectors");
    }

    public void putConnector(String docId, Connector connector, ActionListener<DocWriteResponse> listener) {
        try {
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(docId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(connector.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            this.clientWithOrigin.index(indexRequest, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void postConnector(Connector connector, ActionListener<PostConnectorAction.Response> listener) {
        try {
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(connector.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            this.clientWithOrigin.index(indexRequest, ActionListener.wrap(indexResponse -> listener.onResponse((Object)new PostConnectorAction.Response(indexResponse.getId())), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void getConnector(String connectorId, ActionListener<Connector> listener) {
        try {
            GetRequest getRequest = new GetRequest(CONNECTOR_INDEX_NAME).id(connectorId).realtime(true);
            this.clientWithOrigin.get(getRequest, new DelegatingIndexNotFoundActionListener<GetResponse, Connector>(connectorId, listener, (l, getResponse) -> {
                if (!getResponse.isExists()) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                try {
                    Connector connector = Connector.fromXContentBytes(getResponse.getSourceAsBytesRef(), connectorId, XContentType.JSON);
                    l.onResponse((Object)connector);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteConnector(String connectorId, ActionListener<DeleteResponse> listener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(CONNECTOR_INDEX_NAME).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.clientWithOrigin.delete(deleteRequest, new DelegatingIndexNotFoundActionListener<DeleteResponse, DeleteResponse>(connectorId, listener, (l, deleteResponse) -> {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(deleteResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void listConnectors(int from, int size, final ActionListener<ConnectorResult> listener) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().from(from).size(size).query((QueryBuilder)new MatchAllQueryBuilder()).fetchSource(true).sort(Connector.INDEX_NAME_FIELD.getPreferredName(), SortOrder.ASC);
            SearchRequest req = new SearchRequest(new String[]{CONNECTOR_INDEX_NAME}).source(source);
            this.clientWithOrigin.search(req, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        listener.onResponse((Object)ConnectorIndexService.mapSearchResponseToConnectorList(searchResponse));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new ConnectorResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorConfiguration(UpdateConnectorConfigurationAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.CONFIGURATION_FIELD.getPreferredName(), request.getConfiguration(), Connector.STATUS_FIELD.getPreferredName(), ConnectorStatus.CONFIGURED.toString())));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorError(UpdateConnectorErrorAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorNameOrDescription(UpdateConnectorNameAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorFiltering(UpdateConnectorFilteringAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorLastSeen(UpdateConnectorLastSeenAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorLastSyncStats(UpdateConnectorLastSyncStatsAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorPipeline(UpdateConnectorPipelineAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorScheduling(UpdateConnectorSchedulingAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static ConnectorResult mapSearchResponseToConnectorList(SearchResponse response) {
        List<Connector> connectorResults = Arrays.stream(response.getHits().getHits()).map(ConnectorIndexService::hitToConnector).toList();
        return new ConnectorResult(connectorResults, (int)response.getHits().getTotalHits().value);
    }

    private static Connector hitToConnector(SearchHit searchHit) {
        return Connector.fromXContentBytes(searchHit.getSourceRef(), searchHit.getId(), XContentType.JSON);
    }

    static class DelegatingIndexNotFoundActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String connectorId;

        DelegatingIndexNotFoundActionListener(String connectorId, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.connectorId = connectorId;
        }

        public void onResponse(T t) {
            this.bc.accept((ActionListener<R>)this.delegate, (ActionListener)t);
        }

        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                this.delegate.onFailure((Exception)new ResourceNotFoundException("connector [" + this.connectorId + "] not found", new Object[0]));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public record ConnectorResult(List<Connector> connectors, long totalResults) {
    }
}

