/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;

public class Cauchy
extends AbstractContinuous {
    private final double myLocation;
    private final double myScale;

    public static Cauchy of(double location, double scale) {
        return new Cauchy(location, scale);
    }

    public static Cauchy standard() {
        return new Cauchy();
    }

    public Cauchy() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Cauchy(double location, double scale) {
        this.myLocation = location;
        this.myScale = scale;
    }

    @Override
    public double getDensity(double value) {
        return PrimitiveMath.ONE / (PrimitiveMath.PI * this.myScale * (PrimitiveMath.ONE + Math.pow((value - this.myLocation) / this.myScale, PrimitiveMath.TWO)));
    }

    @Override
    public double getDistribution(double value) {
        return PrimitiveMath.HALF + Math.atan((value - this.myLocation) / this.myScale) / PrimitiveMath.PI;
    }

    @Override
    public double getExpected() {
        return Double.NaN;
    }

    @Override
    public double getQuantile(double probability) {
        return this.myLocation + this.myScale * Math.tan(PrimitiveMath.PI * (probability - PrimitiveMath.HALF));
    }

    @Override
    public double getStandardDeviation() {
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        return Double.NaN;
    }
}

