/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.ql.session.Configuration;

public class EsqlConfiguration
extends Configuration
implements Writeable {
    static final int QUERY_COMPRESS_THRESHOLD_CHARS = ByteSizeUnit.KB.toIntBytes(5L);
    private final QueryPragmas pragmas;
    private final int resultTruncationMaxSize;
    private final int resultTruncationDefaultSize;
    private final Locale locale;
    private final String query;
    private final boolean profile;

    public EsqlConfiguration(ZoneId zi, Locale locale, String username, String clusterName, QueryPragmas pragmas, int resultTruncationMaxSize, int resultTruncationDefaultSize, String query, boolean profile) {
        super(zi, username, clusterName);
        this.locale = locale;
        this.pragmas = pragmas;
        this.resultTruncationMaxSize = resultTruncationMaxSize;
        this.resultTruncationDefaultSize = resultTruncationDefaultSize;
        this.query = query;
        this.profile = profile;
    }

    public EsqlConfiguration(StreamInput in) throws IOException {
        super(in.readZoneId(), Instant.ofEpochSecond(in.readVLong(), in.readVInt()), in.readOptionalString(), in.readOptionalString());
        this.locale = Locale.forLanguageTag(in.readString());
        this.pragmas = new QueryPragmas(in);
        this.resultTruncationMaxSize = in.readVInt();
        this.resultTruncationDefaultSize = in.readVInt();
        this.query = EsqlConfiguration.readQuery(in);
        this.profile = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeZoneId(this.zoneId);
        Instant instant = this.now.toInstant();
        out.writeVLong(instant.getEpochSecond());
        out.writeVInt(instant.getNano());
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.clusterName);
        out.writeString(this.locale.toLanguageTag());
        this.pragmas.writeTo(out);
        out.writeVInt(this.resultTruncationMaxSize);
        out.writeVInt(this.resultTruncationDefaultSize);
        EsqlConfiguration.writeQuery(out, this.query);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE)) {
            out.writeBoolean(this.profile);
        }
    }

    public QueryPragmas pragmas() {
        return this.pragmas;
    }

    public int resultTruncationMaxSize() {
        return this.resultTruncationMaxSize;
    }

    public int resultTruncationDefaultSize() {
        return this.resultTruncationDefaultSize;
    }

    public Locale locale() {
        return this.locale;
    }

    public String query() {
        return this.query;
    }

    public long absoluteStartedTimeInMillis() {
        return System.currentTimeMillis();
    }

    public boolean profile() {
        return this.profile;
    }

    private static void writeQuery(StreamOutput out, String query) throws IOException {
        if (query.length() > QUERY_COMPRESS_THRESHOLD_CHARS) {
            out.writeBoolean(true);
            BytesArray bytesArray = new BytesArray(query.getBytes(StandardCharsets.UTF_8));
            BytesReference bytesRef = CompressorFactory.COMPRESSOR.compress((BytesReference)bytesArray);
            out.writeByteArray(bytesRef.array());
        } else {
            out.writeBoolean(false);
            out.writeString(query);
        }
    }

    private static String readQuery(StreamInput in) throws IOException {
        boolean compressed = in.readBoolean();
        if (compressed) {
            byte[] bytes = in.readByteArray();
            BytesReference bytesRef = CompressorFactory.uncompress((BytesReference)new BytesArray(bytes));
            return new String(bytesRef.array(), StandardCharsets.UTF_8);
        }
        return in.readString();
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            EsqlConfiguration that = (EsqlConfiguration)((Object)o);
            return this.resultTruncationMaxSize == that.resultTruncationMaxSize && this.resultTruncationDefaultSize == that.resultTruncationDefaultSize && Objects.equals(this.pragmas, that.pragmas) && Objects.equals(this.locale, that.locale) && Objects.equals(that.query, this.query) && this.profile == that.profile;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pragmas, this.resultTruncationMaxSize, this.resultTruncationDefaultSize, this.locale, this.query, this.profile);
    }
}

