/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.SourceUtils;

public class SingleValueQuery
extends org.elasticsearch.xpack.ql.querydsl.query.Query {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(QueryBuilder.class, "esql_single_value", Builder::new);
    public static final String MULTI_VALUE_WARNING = "single-value function encountered multi-value";
    private final org.elasticsearch.xpack.ql.querydsl.query.Query next;
    private final String field;
    private static final int SORTED_NUMERIC_MATCH_COST = 10;

    public SingleValueQuery(org.elasticsearch.xpack.ql.querydsl.query.Query next, String field) {
        super(next.source());
        this.next = next;
        this.field = field;
    }

    public boolean containsNestedField(String path, String field) {
        return this.next.containsNestedField(path, field);
    }

    public org.elasticsearch.xpack.ql.querydsl.query.Query addNestedField(String path, String field, String format, boolean hasDocValues) {
        return this.next.addNestedField(path, field, format, hasDocValues);
    }

    public void enrichNestedSort(NestedSortBuilder sort) {
        this.next.enrichNestedSort(sort);
    }

    public Builder asBuilder() {
        return new Builder(this.next.asBuilder(), this.field, new Stats(), this.next.source());
    }

    protected String innerToString() {
        return this.next.toString();
    }

    public SingleValueQuery negate(Source source) {
        return new SingleValueQuery(this.next.negate(source), this.field);
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SingleValueQuery other = (SingleValueQuery)((Object)o);
        return Objects.equals(this.next, other.next) && Objects.equals(this.field, other.field);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.next, this.field);
    }

    public static class Builder
    extends AbstractQueryBuilder<Builder> {
        private final QueryBuilder next;
        private final String field;
        private final Stats stats;
        private final Source source;

        Builder(QueryBuilder next, String field, Stats stats, Source source) {
            this.next = next;
            this.field = field;
            this.stats = stats;
            this.source = source;
        }

        Builder(StreamInput in) throws IOException {
            super(in);
            this.next = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
            this.field = in.readString();
            this.stats = new Stats();
            this.source = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.SOURCE_IN_SINGLE_VALUE_QUERY_ADDED) ? SourceUtils.readSource((StreamInput)in) : Source.EMPTY;
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable((NamedWriteable)this.next);
            out.writeString(this.field);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.SOURCE_IN_SINGLE_VALUE_QUERY_ADDED)) {
                SourceUtils.writeSource((StreamOutput)out, (Source)this.source);
            }
        }

        public QueryBuilder next() {
            return this.next;
        }

        public String field() {
            return this.field;
        }

        public Source source() {
            return this.source;
        }

        public String getWriteableName() {
            return SingleValueQuery.ENTRY.name;
        }

        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(SingleValueQuery.ENTRY.name);
            builder.field("field", this.field);
            builder.field("next", (ToXContent)this.next, params);
            builder.field("source", this.source.toString());
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_500_065;
        }

        protected Query doToQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType ft = context.getFieldType(this.field);
            if (ft == null) {
                ++this.stats.missingField;
                return new MatchNoDocsQuery("missing field [" + this.field + "]");
            }
            return new LuceneQuery(this.next.toQuery(context), context.getForField(ft, MappedFieldType.FielddataOperation.SEARCH), this.stats, new Warnings(this.source));
        }

        protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
            QueryBuilder rewritten = this.next.rewrite(queryRewriteContext);
            if (rewritten instanceof MatchNoneQueryBuilder) {
                ++this.stats.rewrittenToMatchNone;
                return rewritten;
            }
            if (rewritten == this.next) {
                return this;
            }
            return new Builder(rewritten, this.field, this.stats, this.source);
        }

        protected boolean doEquals(Builder other) {
            return this.next.equals(other.next) && this.field.equals(other.field);
        }

        protected int doHashCode() {
            return Objects.hash(this.next, this.field);
        }

        Stats stats() {
            return this.stats;
        }
    }

    static class Stats {
        private int missingField;
        private int rewrittenToMatchNone;
        private int noNextScorer;
        private int numericSingle;
        private int numericMultiNoApprox;
        private int numericMultiApprox;
        private int ordinalsSingle;
        private int ordinalsMultiNoApprox;
        private int ordinalsMultiApprox;
        private int bytesNoApprox;
        private int bytesApprox;

        Stats() {
        }

        int missingField() {
            return this.missingField;
        }

        int rewrittenToMatchNone() {
            return this.rewrittenToMatchNone;
        }

        int noNextScorer() {
            return this.noNextScorer;
        }

        int numericSingle() {
            return this.numericSingle;
        }

        int numericMultiNoApprox() {
            return this.numericMultiNoApprox;
        }

        int numericMultiApprox() {
            return this.numericMultiApprox;
        }

        int ordinalsSingle() {
            return this.ordinalsSingle;
        }

        int ordinalsMultiNoApprox() {
            return this.ordinalsMultiNoApprox;
        }

        int ordinalsMultiApprox() {
            return this.ordinalsMultiApprox;
        }

        int bytesNoApprox() {
            return this.bytesNoApprox;
        }

        int bytesApprox() {
            return this.bytesApprox;
        }
    }

    private static class TwoPhaseIteratorForSortedBinaryAndTwoPhaseQueries
    extends TwoPhaseIterator {
        private final SortedBinaryDocValues sortedBinary;
        private final TwoPhaseIterator next;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedBinaryAndTwoPhaseQueries(TwoPhaseIterator next, SortedBinaryDocValues sortedBinary, Warnings warnings) {
            super(next.approximation());
            this.sortedBinary = sortedBinary;
            this.next = next;
            this.warnings = warnings;
        }

        public boolean matches() throws IOException {
            if (!this.sortedBinary.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedBinary.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return this.next.matches();
        }

        public float matchCost() {
            return 10.0f + this.next.matchCost();
        }
    }

    private static class TwoPhaseIteratorForSortedSetAndSinglePhaseQueries
    extends TwoPhaseIterator {
        private final SortedSetDocValues sortedSet;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedSetAndSinglePhaseQueries(DocIdSetIterator approximation, SortedSetDocValues sortedSet, Warnings warnings) {
            super(approximation);
            this.sortedSet = sortedSet;
            this.warnings = warnings;
        }

        public boolean matches() throws IOException {
            if (!this.sortedSet.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedSet.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return true;
        }

        public float matchCost() {
            return 10.0f;
        }
    }

    private static class TwoPhaseIteratorForSortedSetAndTwoPhaseQueries
    extends TwoPhaseIterator {
        private final SortedSetDocValues sortedSet;
        private final TwoPhaseIterator next;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedSetAndTwoPhaseQueries(TwoPhaseIterator next, SortedSetDocValues sortedSet, Warnings warnings) {
            super(next.approximation());
            this.sortedSet = sortedSet;
            this.next = next;
            this.warnings = warnings;
        }

        public boolean matches() throws IOException {
            if (!this.sortedSet.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedSet.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return this.next.matches();
        }

        public float matchCost() {
            return 10.0f + this.next.matchCost();
        }
    }

    private static class TwoPhaseIteratorForSortedBinaryAndSinglePhaseQueries
    extends TwoPhaseIterator {
        private final SortedBinaryDocValues sortedBinary;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedBinaryAndSinglePhaseQueries(DocIdSetIterator approximation, SortedBinaryDocValues sortedBinary, Warnings warnings) {
            super(approximation);
            this.sortedBinary = sortedBinary;
            this.warnings = warnings;
        }

        public boolean matches() throws IOException {
            if (!this.sortedBinary.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedBinary.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return true;
        }

        public float matchCost() {
            return 10.0f;
        }
    }

    private static class TwoPhaseIteratorForSortedNumericsAndTwoPhaseQueries
    extends TwoPhaseIterator {
        private final SortedNumericDocValues sortedNumerics;
        private final TwoPhaseIterator next;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedNumericsAndTwoPhaseQueries(TwoPhaseIterator next, SortedNumericDocValues sortedNumerics, Warnings warnings) {
            super(next.approximation());
            this.sortedNumerics = sortedNumerics;
            this.next = next;
            this.warnings = warnings;
        }

        public boolean matches() throws IOException {
            if (!this.sortedNumerics.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedNumerics.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return this.next.matches();
        }

        public float matchCost() {
            return 10.0f + this.next.matchCost();
        }
    }

    private static class TwoPhaseIteratorForSortedNumericsAndSinglePhaseQueries
    extends TwoPhaseIterator {
        private final SortedNumericDocValues sortedNumerics;
        private final Warnings warnings;

        private TwoPhaseIteratorForSortedNumericsAndSinglePhaseQueries(DocIdSetIterator approximation, SortedNumericDocValues sortedNumerics, Warnings warning) {
            super(approximation);
            this.sortedNumerics = sortedNumerics;
            this.warnings = warning;
        }

        public boolean matches() throws IOException {
            if (!this.sortedNumerics.advanceExact(this.approximation.docID())) {
                return false;
            }
            if (this.sortedNumerics.docValueCount() != 1) {
                this.warnings.registerException(new IllegalArgumentException(SingleValueQuery.MULTI_VALUE_WARNING));
                return false;
            }
            return true;
        }

        public float matchCost() {
            return 10.0f;
        }
    }

    private static class SingleValueQueryScorer
    extends Scorer {
        private final Scorer next;
        private final TwoPhaseIterator iterator;

        private SingleValueQueryScorer(Weight weight, Scorer next, TwoPhaseIterator iterator) {
            super(weight);
            this.next = next;
            this.iterator = iterator;
        }

        public DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.iterator);
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.iterator;
        }

        public float getMaxScore(int upTo) throws IOException {
            return this.next.getMaxScore(upTo);
        }

        public float score() throws IOException {
            return this.next.score();
        }

        public int docID() {
            return this.next.docID();
        }
    }

    private static class SingleValueWeight
    extends Weight {
        private final Stats stats;
        private final Weight next;
        private final IndexFieldData<?> fieldData;
        private final Warnings warnings;

        private SingleValueWeight(LuceneQuery query, Weight next, IndexFieldData<?> fieldData, Warnings warnings) {
            super((Query)query);
            this.stats = query.stats;
            this.next = next;
            this.fieldData = fieldData;
            this.warnings = warnings;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation nextExplanation = this.next.explain(context, doc);
            if (!nextExplanation.isMatch()) {
                return Explanation.noMatch((String)"next didn't match", (Explanation[])new Explanation[]{nextExplanation});
            }
            LeafFieldData lfd = this.fieldData.load(context);
            SortedBinaryDocValues values = lfd.getBytesValues();
            if (!values.advanceExact(doc)) {
                return Explanation.noMatch((String)"no values in field", (Explanation[])new Explanation[]{nextExplanation});
            }
            if (values.docValueCount() != 1) {
                return Explanation.noMatch((String)("field has too many values [" + values.docValueCount() + "]"), (Explanation[])new Explanation[]{nextExplanation});
            }
            return Explanation.match((Number)nextExplanation.getValue(), (String)"field has exactly 1 value", (Explanation[])new Explanation[]{nextExplanation});
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer nextScorer = this.next.scorer(context);
            if (nextScorer == null) {
                ++this.stats.noNextScorer;
                return null;
            }
            LeafFieldData lfd = this.fieldData.load(context);
            if (lfd instanceof LeafNumericFieldData) {
                LeafNumericFieldData n = (LeafNumericFieldData)lfd;
                return this.scorer(context, nextScorer, n);
            }
            if (lfd instanceof LeafOrdinalsFieldData) {
                LeafOrdinalsFieldData o = (LeafOrdinalsFieldData)lfd;
                return this.scorer(context, nextScorer, o);
            }
            return this.scorer(nextScorer, lfd);
        }

        private Scorer scorer(LeafReaderContext context, Scorer nextScorer, LeafNumericFieldData lfd) throws IOException {
            PointValues points;
            SortedNumericDocValues sortedNumerics = lfd.getLongValues();
            if (DocValues.unwrapSingleton((SortedNumericDocValues)sortedNumerics) != null && (points = context.reader().getPointValues(this.fieldData.getFieldName())) != null && points.getDocCount() == context.reader().maxDoc()) {
                ++this.stats.numericSingle;
                return nextScorer;
            }
            TwoPhaseIterator nextIterator = nextScorer.twoPhaseIterator();
            if (nextIterator == null) {
                ++this.stats.numericMultiNoApprox;
                return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedNumericsAndSinglePhaseQueries(nextScorer.iterator(), sortedNumerics, this.warnings));
            }
            ++this.stats.numericMultiApprox;
            return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedNumericsAndTwoPhaseQueries(nextIterator, sortedNumerics, this.warnings));
        }

        private Scorer scorer(LeafReaderContext context, Scorer nextScorer, LeafOrdinalsFieldData lfd) throws IOException {
            Terms terms;
            SortedSetDocValues sortedSet = lfd.getOrdinalsValues();
            if (DocValues.unwrapSingleton((SortedSetDocValues)sortedSet) != null && (terms = context.reader().terms(this.fieldData.getFieldName())) != null && terms.getDocCount() == context.reader().maxDoc()) {
                ++this.stats.ordinalsSingle;
                return nextScorer;
            }
            TwoPhaseIterator nextIterator = nextScorer.twoPhaseIterator();
            if (nextIterator == null) {
                ++this.stats.ordinalsMultiNoApprox;
                return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedSetAndSinglePhaseQueries(nextScorer.iterator(), sortedSet, this.warnings));
            }
            ++this.stats.ordinalsMultiApprox;
            return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedSetAndTwoPhaseQueries(nextIterator, sortedSet, this.warnings));
        }

        private Scorer scorer(Scorer nextScorer, LeafFieldData lfd) {
            SortedBinaryDocValues sortedBinary = lfd.getBytesValues();
            TwoPhaseIterator nextIterator = nextScorer.twoPhaseIterator();
            if (nextIterator == null) {
                ++this.stats.bytesNoApprox;
                return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedBinaryAndSinglePhaseQueries(nextScorer.iterator(), sortedBinary, this.warnings));
            }
            ++this.stats.bytesApprox;
            return new SingleValueQueryScorer(this, nextScorer, new TwoPhaseIteratorForSortedBinaryAndTwoPhaseQueries(nextIterator, sortedBinary, this.warnings));
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.next.isCacheable(ctx);
        }
    }

    private static class LuceneQuery
    extends Query {
        final Query next;
        private final IndexFieldData<?> fieldData;
        private final Stats stats;
        private final Warnings warnings;

        LuceneQuery(Query next, IndexFieldData<?> fieldData, Stats stats, Warnings warnings) {
            this.next = next;
            this.fieldData = fieldData;
            this.stats = stats;
            this.warnings = warnings;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.fieldData.getFieldName())) {
                visitor.visitLeaf(this.next);
            }
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query rewritten = this.next.rewrite(reader);
            if (rewritten instanceof MatchNoDocsQuery) {
                ++this.stats.rewrittenToMatchNone;
                return rewritten;
            }
            if (rewritten == this.next) {
                return this;
            }
            return new LuceneQuery(rewritten, this.fieldData, this.stats, this.warnings);
        }

        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            return new SingleValueWeight(this, this.next.createWeight(searcher, scoreMode, boost), this.fieldData, this.warnings);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            LuceneQuery other = (LuceneQuery)((Object)obj);
            return this.next.equals((Object)other.next) && this.fieldData.getFieldName().equals(other.fieldData.getFieldName()) && this.warnings.equals(other.warnings);
        }

        public int hashCode() {
            return Objects.hash(this.classHash(), this.next, this.fieldData, this.warnings);
        }

        public String toString(String field) {
            StringBuilder builder = new StringBuilder("single_value(");
            if (!this.fieldData.getFieldName().equals(field)) {
                builder.append(this.fieldData.getFieldName());
                builder.append(":");
            }
            builder.append(this.next);
            return builder.append(")").toString();
        }
    }
}

