/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslator;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.planner.QlTranslatorHandler;
import org.elasticsearch.xpack.ql.planner.TranslatorHandler;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.ql.type.DataType;

public final class EsqlTranslatorHandler
extends QlTranslatorHandler {
    public static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = List.of(new ExpressionTranslator[]{new ExpressionTranslators.BinaryComparisons(), new ExpressionTranslators.Ranges(), new ExpressionTranslators.BinaryLogic(), new ExpressionTranslators.IsNulls(), new ExpressionTranslators.IsNotNulls(), new ExpressionTranslators.Nots(), new ExpressionTranslators.Likes(), new ExpressionTranslators.InComparisons(), new ExpressionTranslators.StringQueries(), new ExpressionTranslators.Matches(), new ExpressionTranslators.MultiMatches(), new Scalars()});

    public Query asQuery(Expression e) {
        Query translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, (TranslatorHandler)this);
            if (translation == null) continue;
            return translation;
        }
        throw new QlIllegalArgumentException("Don't know how to translate {} {}", new Object[]{e.nodeName(), e});
    }

    public Object convert(Object value, DataType dataType) {
        return EsqlDataTypeConverter.convert(value, dataType);
    }

    public Query wrapFunctionQuery(ScalarFunction sf, Expression field, Supplier<Query> querySupplier) {
        if (field instanceof FieldAttribute) {
            FieldAttribute exact;
            FieldAttribute fa = (FieldAttribute)field;
            if (fa.getExactInfo().hasExact() && (exact = fa.exactAttribute()) != fa) {
                fa = exact;
            }
            Query query = querySupplier.get();
            if (!(sf instanceof IsNull || sf instanceof IsNotNull)) {
                query = new SingleValueQuery(query, fa.name());
            }
            return ExpressionTranslator.wrapIfNested((Query)query, (Expression)field);
        }
        if (field instanceof MetadataAttribute) {
            return querySupplier.get();
        }
        throw new EsqlIllegalArgumentException("Expected a FieldAttribute or MetadataAttribute but received [" + field + "]");
    }

    public static class Scalars
    extends ExpressionTranslator<ScalarFunction> {
        protected Query asQuery(ScalarFunction f, TranslatorHandler handler) {
            return Scalars.doTranslate(f, handler);
        }

        public static Query doTranslate(ScalarFunction f, TranslatorHandler handler) {
            CIDRMatch cm;
            Expression expression;
            if (f instanceof CIDRMatch && (expression = (cm = (CIDRMatch)f).ipField()) instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)expression;
                if (Expressions.foldable(cm.matches())) {
                    String targetFieldName = handler.nameOf((Expression)fa.exactAttribute());
                    LinkedHashSet set = new LinkedHashSet(Expressions.fold(cm.matches()));
                    TermsQuery query = new TermsQuery(f.source(), targetFieldName, set);
                    return handler.wrapFunctionQuery(f, cm.ipField(), () -> Scalars.lambda$doTranslate$0((Query)query));
                }
            }
            return ExpressionTranslators.Scalars.doTranslate((ScalarFunction)f, (TranslatorHandler)handler);
        }

        private static /* synthetic */ Query lambda$doTranslate$0(Query query) {
            return query;
        }
    }
}

