/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.show;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ShowFunctions
extends LeafPlan {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public ShowFunctions(Source source) {
        super(source);
        for (String name : List.of("name", "synopsis", "argNames", "argTypes", "argDescriptions", "returnType", "description")) {
            this.attributes.add((Attribute)new ReferenceAttribute(Source.EMPTY, name, DataTypes.KEYWORD));
        }
        for (String name : List.of("optionalArgs", "variadic")) {
            this.attributes.add((Attribute)new ReferenceAttribute(Source.EMPTY, name, DataTypes.BOOLEAN));
        }
    }

    public List<Attribute> output() {
        return this.attributes;
    }

    public List<List<Object>> values(FunctionRegistry functionRegistry) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (FunctionDefinition def : functionRegistry.listFunctions(null)) {
            EsqlFunctionRegistry.FunctionDescription signature = EsqlFunctionRegistry.description(def);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(ShowFunctions.asBytesRefOrNull(signature.name()));
            row.add(new BytesRef((CharSequence)signature.fullSignature()));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::name));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::type));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::description));
            row.add(ShowFunctions.withPipes(signature.returnType()));
            row.add(signature.description());
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::optional));
            row.add(signature.variadic());
            rows.add(row);
        }
        rows.sort(Comparator.comparing(x -> (BytesRef)x.get(0)));
        return rows;
    }

    private Object collect(EsqlFunctionRegistry.FunctionDescription signature, Function<EsqlFunctionRegistry.ArgSignature, ?> x) {
        if (signature.args().size() == 0) {
            return null;
        }
        if (signature.args().size() == 1) {
            Object result = x.apply(signature.args().get(0));
            if (result instanceof String[]) {
                String[] r = (String[])result;
                return ShowFunctions.withPipes(r);
            }
            return result;
        }
        List result = signature.args().stream().map(x).collect(Collectors.toList());
        if (!result.isEmpty() && result.get(0) instanceof String[]) {
            ArrayList<String> newResult = new ArrayList<String>();
            for (Object item : result) {
                newResult.add(ShowFunctions.withPipes((String[])item));
            }
            return newResult;
        }
        return result;
    }

    public static String withPipes(String[] items) {
        return Arrays.stream(items).collect(Collectors.joining("|"));
    }

    private static BytesRef asBytesRefOrNull(String string) {
        return Strings.hasText((String)string) ? new BytesRef((CharSequence)string) : null;
    }

    public boolean expressionsResolved() {
        return true;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }
}

