/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.TypedParamValue;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsqlUnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowFunctions;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class LogicalPlanBuilder
extends ExpressionBuilder {
    public LogicalPlanBuilder(Map<Token, TypedParamValue> params) {
        super(params);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return (LogicalPlan)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList((ParseTreeVisitor)this, ctxs, LogicalPlan.class);
    }

    @Override
    public LogicalPlan visitSingleStatement(EsqlBaseParser.SingleStatementContext ctx) {
        return this.plan((ParseTree)ctx.query());
    }

    @Override
    public LogicalPlan visitCompositeQuery(EsqlBaseParser.CompositeQueryContext ctx) {
        LogicalPlan input = this.plan((ParseTree)ctx.query());
        PlanFactory makePlan = (PlanFactory)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx.processingCommand(), PlanFactory.class);
        return (LogicalPlan)makePlan.apply(input);
    }

    @Override
    public PlanFactory visitEvalCommand(EsqlBaseParser.EvalCommandContext ctx) {
        return p -> new Eval(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)p, (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public PlanFactory visitGrokCommand(EsqlBaseParser.GrokCommandContext ctx) {
        return p -> {
            String pattern = this.visitString(ctx.string()).fold().toString();
            Grok result = new Grok(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)p, this.expression((ParseTree)ctx.primaryExpression()), Grok.pattern(ParserUtils.source((ParserRuleContext)ctx), pattern));
            return result;
        };
    }

    @Override
    public PlanFactory visitDissectCommand(EsqlBaseParser.DissectCommandContext ctx) {
        return p -> {
            String pattern = this.visitString(ctx.string()).fold().toString();
            Object options = this.visitCommandOptions(ctx.commandOptions());
            String appendSeparator = "";
            for (Map.Entry item : options.entrySet()) {
                if (!((String)item.getKey()).equalsIgnoreCase("append_separator")) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Invalid option for dissect: [{}]", item.getKey());
                }
                if (!(item.getValue() instanceof String)) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Invalid value for dissect append_separator: expected a string, but was [{}]", item.getValue());
                }
                appendSeparator = (String)item.getValue();
            }
            Source src = ParserUtils.source((ParserRuleContext)ctx);
            try {
                DissectParser parser = new DissectParser(pattern, appendSeparator);
                Set referenceKeys = parser.referenceKeys();
                if (referenceKeys.size() > 0) {
                    throw new ParsingException(src, "Reference keys not supported in dissect patterns: [%{*{}}]", referenceKeys.iterator().next());
                }
                ArrayList<Attribute> keys = new ArrayList<Attribute>();
                for (String x : parser.outputKeys()) {
                    if (x.isEmpty()) continue;
                    keys.add((Attribute)new ReferenceAttribute(src, x, DataTypes.KEYWORD));
                }
                return new Dissect(src, (LogicalPlan)p, this.expression((ParseTree)ctx.primaryExpression()), new Dissect.Parser(pattern, appendSeparator, parser), (List<Attribute>)keys);
            }
            catch (DissectException e) {
                throw new ParsingException(src, "Invalid pattern for dissect: [{}]", pattern);
            }
        };
    }

    @Override
    public PlanFactory visitMvExpandCommand(EsqlBaseParser.MvExpandCommandContext ctx) {
        String identifier = this.visitSourceIdentifier(ctx.sourceIdentifier());
        Source src = ParserUtils.source((ParserRuleContext)ctx);
        return child -> new MvExpand(src, (LogicalPlan)child, (NamedExpression)new UnresolvedAttribute(src, identifier), (Attribute)new UnresolvedAttribute(src, identifier));
    }

    @Override
    public Map<String, Object> visitCommandOptions(EsqlBaseParser.CommandOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsqlBaseParser.CommandOptionContext option : ctx.commandOption()) {
            result.put(this.visitIdentifier(option.identifier()), this.expression((ParseTree)option.constant()).fold());
        }
        return result;
    }

    @Override
    public LogicalPlan visitRowCommand(EsqlBaseParser.RowCommandContext ctx) {
        return new Row(ParserUtils.source((ParserRuleContext)ctx), (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public LogicalPlan visitFromCommand(EsqlBaseParser.FromCommandContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        TableIdentifier table = new TableIdentifier(source, null, this.visitSourceIdentifiers((List)ctx.sourceIdentifier()));
        LinkedHashMap<String, MetadataAttribute> metadataMap = new LinkedHashMap<String, MetadataAttribute>();
        if (ctx.metadata() != null) {
            for (EsqlBaseParser.SourceIdentifierContext c : ctx.metadata().sourceIdentifier()) {
                String id = this.visitSourceIdentifier(c);
                Source src = ParserUtils.source((ParserRuleContext)c);
                if (!MetadataAttribute.isSupported((String)id)) {
                    throw new ParsingException(src, "unsupported metadata field [" + id + "]", new Object[0]);
                }
                Attribute a = (Attribute)metadataMap.put(id, MetadataAttribute.create((Source)src, (String)id));
                if (a == null) continue;
                throw new ParsingException(src, "metadata field [" + id + "] already declared [" + a.source().source() + "]", new Object[0]);
            }
        }
        return new EsqlUnresolvedRelation(source, table, Arrays.asList((Attribute[])metadataMap.values().toArray(Attribute[]::new)));
    }

    @Override
    public PlanFactory visitStatsCommand(EsqlBaseParser.StatsCommandContext ctx) {
        ArrayList aggregates = new ArrayList(this.visitFields(ctx.fields()));
        Object groupings = this.visitGrouping(ctx.grouping());
        if (aggregates.isEmpty() && groupings.isEmpty()) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "At least one aggregation or grouping expression required in [{}]", ctx.getText());
        }
        if (!groupings.isEmpty() && !aggregates.isEmpty()) {
            List groupNames = Expressions.names((Collection)groupings);
            for (NamedExpression aggregate : aggregates) {
                UnresolvedAttribute ua;
                Alias a;
                Expression expression;
                if (!(aggregate instanceof Alias) || !((expression = (a = (Alias)aggregate).child()) instanceof UnresolvedAttribute) || !groupNames.contains((ua = (UnresolvedAttribute)expression).name())) continue;
                throw new ParsingException(ua.source(), "Cannot specify grouping expression [{}] as an aggregate", ua.name());
            }
        }
        aggregates.addAll(groupings);
        return arg_0 -> LogicalPlanBuilder.lambda$visitStatsCommand$5(ctx, (List)groupings, aggregates, arg_0);
    }

    @Override
    public PlanFactory visitInlinestatsCommand(EsqlBaseParser.InlinestatsCommandContext ctx) {
        ArrayList aggregates = new ArrayList(this.visitFields(ctx.fields()));
        Object groupings = this.visitGrouping(ctx.grouping());
        aggregates.addAll(groupings);
        return arg_0 -> LogicalPlanBuilder.lambda$visitInlinestatsCommand$6(ctx, (List)groupings, aggregates, arg_0);
    }

    @Override
    public PlanFactory visitWhereCommand(EsqlBaseParser.WhereCommandContext ctx) {
        Expression expression = this.expression((ParseTree)ctx.booleanExpression());
        return input -> new Filter(ParserUtils.source((ParserRuleContext)ctx), input, expression);
    }

    @Override
    public List<Alias> visitFields(EsqlBaseParser.FieldsContext ctx) {
        return ctx != null ? ParserUtils.visitList((ParseTreeVisitor)this, ctx.field(), Alias.class) : new ArrayList<Alias>();
    }

    @Override
    public PlanFactory visitLimitCommand(EsqlBaseParser.LimitCommandContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        int limit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        return input -> new Limit(source, (Expression)new Literal(source, (Object)limit, DataTypes.INTEGER), input);
    }

    @Override
    public PlanFactory visitSortCommand(EsqlBaseParser.SortCommandContext ctx) {
        List orders = ParserUtils.visitList((ParseTreeVisitor)this, ctx.orderExpression(), Order.class);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return input -> new OrderBy(source, input, orders);
    }

    @Override
    public Explain visitExplainCommand(EsqlBaseParser.ExplainCommandContext ctx) {
        return new Explain(ParserUtils.source((ParserRuleContext)ctx), this.plan((ParseTree)ctx.subqueryExpression().query()));
    }

    @Override
    public PlanFactory visitDropCommand(EsqlBaseParser.DropCommandContext ctx) {
        List<EsqlBaseParser.SourceIdentifierContext> identifiers = ctx.sourceIdentifier();
        ArrayList<UnresolvedAttribute> removals = new ArrayList<UnresolvedAttribute>(identifiers.size());
        for (EsqlBaseParser.SourceIdentifierContext idCtx : identifiers) {
            Source src = ParserUtils.source((ParserRuleContext)idCtx);
            String identifier = this.visitSourceIdentifier(idCtx);
            if (identifier.equals("*")) {
                throw new ParsingException(src, "Removing all fields is not allowed [{}]", src.text());
            }
            removals.add(new UnresolvedAttribute(src, identifier));
        }
        return child -> new Drop(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, (List<NamedExpression>)removals);
    }

    @Override
    public PlanFactory visitRenameCommand(EsqlBaseParser.RenameCommandContext ctx) {
        List<Alias> renamings = ctx.renameClause().stream().map(this::visitRenameClause).toList();
        return child -> new Rename(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, renamings);
    }

    @Override
    public PlanFactory visitKeepCommand(EsqlBaseParser.KeepCommandContext ctx) {
        if (ctx.PROJECT() != null) {
            HeaderWarning.addWarning((String)"PROJECT command is no longer supported, please use KEEP instead", (Object[])new Object[0]);
        }
        ArrayList<NamedExpression> projections = new ArrayList<NamedExpression>(ctx.sourceIdentifier().size());
        boolean hasSeenStar = false;
        for (EsqlBaseParser.SourceIdentifierContext srcIdCtx : ctx.sourceIdentifier()) {
            NamedExpression ne = this.visitProjectExpression(srcIdCtx);
            if (ne instanceof UnresolvedStar) {
                if (hasSeenStar) {
                    throw new ParsingException(ne.source(), "Cannot specify [*] more than once", ne.source().text());
                }
                hasSeenStar = true;
            }
            projections.add(ne);
        }
        return child -> new Keep(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, (List<? extends NamedExpression>)projections);
    }

    @Override
    public LogicalPlan visitShowInfo(EsqlBaseParser.ShowInfoContext ctx) {
        return new ShowInfo(ParserUtils.source((ParserRuleContext)ctx));
    }

    @Override
    public LogicalPlan visitShowFunctions(EsqlBaseParser.ShowFunctionsContext ctx) {
        return new ShowFunctions(ParserUtils.source((ParserRuleContext)ctx));
    }

    @Override
    public PlanFactory visitEnrichCommand(EsqlBaseParser.EnrichCommandContext ctx) {
        return p -> {
            UnresolvedAttribute matchField;
            String policyName = this.visitSourceIdentifier(ctx.policyName);
            Source source = ParserUtils.source((ParserRuleContext)ctx);
            Object object = matchField = ctx.ON() != null ? new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx.matchField), this.visitSourceIdentifier(ctx.matchField)) : new EmptyAttribute(source);
            if (matchField.name().contains("*")) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Using wildcards (*) in ENRICH WITH projections is not allowed [{}]", matchField.name());
            }
            List keepClauses = ParserUtils.visitList((ParseTreeVisitor)this, ctx.enrichWithClause(), NamedExpression.class);
            return new Enrich(source, (LogicalPlan)p, (Expression)new Literal(ParserUtils.source((ParserRuleContext)ctx.policyName), (Object)policyName, DataTypes.KEYWORD), (NamedExpression)matchField, null, keepClauses.isEmpty() ? List.of() : keepClauses);
        };
    }

    @Override
    public NamedExpression visitEnrichWithClause(EsqlBaseParser.EnrichWithClauseContext ctx) {
        Source src = ParserUtils.source((ParserRuleContext)ctx);
        String enrichField = this.enrichFieldName(ctx.enrichField);
        String newName = this.enrichFieldName(ctx.newName);
        UnresolvedAttribute enrichAttr = new UnresolvedAttribute(src, enrichField);
        return newName == null ? enrichAttr : new Alias(src, newName, (Expression)enrichAttr);
    }

    private String enrichFieldName(EsqlBaseParser.SourceIdentifierContext ctx) {
        String name;
        String string = name = ctx == null ? null : this.visitSourceIdentifier(ctx);
        if (name != null && name.contains("*")) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Using wildcards (*) in ENRICH WITH projections is not allowed [{}]", name);
        }
        return name;
    }

    private static /* synthetic */ LogicalPlan lambda$visitInlinestatsCommand$6(EsqlBaseParser.InlinestatsCommandContext ctx, List groupings, List aggregates, LogicalPlan input) {
        return new InlineStats(ParserUtils.source((ParserRuleContext)ctx), input, new ArrayList<Expression>(groupings), aggregates);
    }

    private static /* synthetic */ LogicalPlan lambda$visitStatsCommand$5(EsqlBaseParser.StatsCommandContext ctx, List groupings, List aggregates, LogicalPlan input) {
        return new Aggregate(ParserUtils.source((ParserRuleContext)ctx), input, new ArrayList(groupings), aggregates);
    }

    static interface PlanFactory
    extends Function<LogicalPlan, LogicalPlan> {
    }
}

