/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.math.BigInteger;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.regex.RLike;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.regex.WildcardLike;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.TypedParamValue;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.ql.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.ql.util.StringUtils;

public abstract class ExpressionBuilder
extends IdentifierBuilder {
    private final Map<Token, TypedParamValue> params;

    ExpressionBuilder(Map<Token, TypedParamValue> params) {
        this.params = params;
    }

    protected Expression expression(ParseTree ctx) {
        return (Expression)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return ParserUtils.visitList((ParseTreeVisitor)this, contexts, Expression.class);
    }

    @Override
    public Literal visitBooleanValue(EsqlBaseParser.BooleanValueContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return new Literal(source, (Object)(ctx.TRUE() != null ? 1 : 0), DataTypes.BOOLEAN);
    }

    @Override
    public Literal visitDecimalValue(EsqlBaseParser.DecimalValueContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        String text = ctx.getText();
        try {
            return new Literal(source, (Object)StringUtils.parseDouble((String)text), DataTypes.DOUBLE);
        }
        catch (InvalidArgumentException iae) {
            throw new ParsingException(source, iae.getMessage(), new Object[0]);
        }
    }

    @Override
    public Literal visitIntegerValue(EsqlBaseParser.IntegerValueContext ctx) {
        DataType type;
        Number val;
        Number number;
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        String text = ctx.getText();
        try {
            number = StringUtils.parseIntegral((String)text);
        }
        catch (InvalidArgumentException siae) {
            try {
                return new Literal(source, (Object)StringUtils.parseDouble((String)text), DataTypes.DOUBLE);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                throw new ParsingException(source, siae.getMessage(), new Object[0]);
            }
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            val = NumericUtils.asLongUnsigned((BigInteger)bi);
            type = DataTypes.UNSIGNED_LONG;
        } else if ((long)number.intValue() == number.longValue()) {
            val = number.intValue();
            type = DataTypes.INTEGER;
        } else {
            val = number.longValue();
            type = DataTypes.LONG;
        }
        return new Literal(source, (Object)val, type);
    }

    @Override
    public Object visitNumericArrayLiteral(EsqlBaseParser.NumericArrayLiteralContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        List numbers = ParserUtils.visitList((ParseTreeVisitor)this, ctx.numericValue(), Literal.class);
        if (numbers.stream().anyMatch(l -> l.dataType() == DataTypes.DOUBLE)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.doubleValue()), DataTypes.DOUBLE);
        }
        if (numbers.stream().anyMatch(l -> l.dataType() == DataTypes.UNSIGNED_LONG)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> dt == DataTypes.UNSIGNED_LONG ? no.longValue() : NumericUtils.asLongUnsigned((BigInteger)BigInteger.valueOf(no.longValue()))), DataTypes.UNSIGNED_LONG);
        }
        if (numbers.stream().anyMatch(l -> l.dataType() == DataTypes.LONG)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.longValue()), DataTypes.LONG);
        }
        return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.intValue()), DataTypes.INTEGER);
    }

    private List<Object> mapNumbers(List<Literal> numbers, BiFunction<Number, DataType, Object> map) {
        return numbers.stream().map(l -> map.apply((Number)l.value(), l.dataType())).toList();
    }

    @Override
    public Object visitBooleanArrayLiteral(EsqlBaseParser.BooleanArrayLiteralContext ctx) {
        return this.visitArrayLiteral(ctx, ctx.booleanValue(), DataTypes.BOOLEAN);
    }

    @Override
    public Object visitStringArrayLiteral(EsqlBaseParser.StringArrayLiteralContext ctx) {
        return this.visitArrayLiteral(ctx, ctx.string(), DataTypes.KEYWORD);
    }

    private Object visitArrayLiteral(ParserRuleContext ctx, List<? extends ParserRuleContext> contexts, DataType dataType) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        List literals = ParserUtils.visitList((ParseTreeVisitor)this, contexts, Literal.class);
        return new Literal(source, literals.stream().map(Literal::value).toList(), dataType);
    }

    @Override
    public Literal visitNullLiteral(EsqlBaseParser.NullLiteralContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return new Literal(source, null, DataTypes.NULL);
    }

    @Override
    public Literal visitStringLiteral(EsqlBaseParser.StringLiteralContext ctx) {
        return this.visitString(ctx.string());
    }

    @Override
    public Literal visitString(EsqlBaseParser.StringContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return new Literal(source, (Object)ExpressionBuilder.unquoteString(source), DataTypes.KEYWORD);
    }

    @Override
    public UnresolvedAttribute visitQualifiedName(EsqlBaseParser.QualifiedNameContext ctx) {
        if (ctx == null) {
            return null;
        }
        return new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx), Strings.collectionToDelimitedString((Iterable)ParserUtils.visitList((ParseTreeVisitor)this, ctx.identifier(), String.class), (String)"."));
    }

    @Override
    public Object visitQualifiedIntegerLiteral(EsqlBaseParser.QualifiedIntegerLiteralContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Literal intLit = (Literal)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx.integerValue(), Literal.class);
        Number value = (Number)intLit.value();
        if (intLit.dataType() == DataTypes.UNSIGNED_LONG) {
            value = NumericUtils.unsignedLongAsNumber((long)value.longValue());
        }
        String qualifier = ctx.UNQUOTED_IDENTIFIER().getText().toLowerCase(Locale.ROOT);
        try {
            TemporalAmount quantity = EsqlDataTypeConverter.parseTemporalAmout(value, qualifier, source);
            return new Literal(source, (Object)quantity, quantity instanceof Duration ? EsqlDataTypes.TIME_DURATION : EsqlDataTypes.DATE_PERIOD);
        }
        catch (ArithmeticException | InvalidArgumentException e) {
            throw new ParsingException(source, "Number [{}] outside of [{}] range", ctx.integerValue().getText(), qualifier);
        }
    }

    @Override
    public Expression visitArithmeticUnary(EsqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression expr = this.expression((ParseTree)ctx.operatorExpression());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        int type = ctx.operator.getType();
        return type == 61 ? new Neg(source, expr) : expr;
    }

    @Override
    public Expression visitArithmeticBinary(EsqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        int type = ctx.operator.getType();
        return switch (type) {
            case 62 -> new Mul(source, left, right);
            case 63 -> new Div(source, left, right);
            case 64 -> new Mod(source, left, right);
            case 60 -> new Add(source, left, right);
            case 61 -> new Sub(source, left, right);
            default -> throw new ParsingException(source, "Unknown arithmetic operator {}", source.text());
        };
    }

    @Override
    public Expression visitComparison(EsqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        ZoneId zoneId = DateUtils.UTC;
        return switch (op.getSymbol().getType()) {
            case 54 -> new Equals(source, left, right, zoneId);
            case 55 -> new Not(source, (Expression)new Equals(source, left, right, zoneId));
            case 56 -> new LessThan(source, left, right, zoneId);
            case 57 -> new LessThanOrEqual(source, left, right, zoneId);
            case 58 -> new GreaterThan(source, left, right, zoneId);
            case 59 -> new GreaterThanOrEqual(source, left, right, zoneId);
            default -> throw new ParsingException(source, "Unknown comparison operator {}", source.text());
        };
    }

    @Override
    public Not visitLogicalNot(EsqlBaseParser.LogicalNotContext ctx) {
        return new Not(ParserUtils.source((ParserRuleContext)ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Expression visitParenthesizedExpression(EsqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.booleanExpression());
    }

    @Override
    public Expression visitOperatorExpressionDefault(EsqlBaseParser.OperatorExpressionDefaultContext ctx) {
        return this.expression((ParseTree)ctx.primaryExpression());
    }

    @Override
    public UnresolvedAttribute visitDereference(EsqlBaseParser.DereferenceContext ctx) {
        return this.visitQualifiedName(ctx.qualifiedName());
    }

    @Override
    public Expression visitFunctionExpression(EsqlBaseParser.FunctionExpressionContext ctx) {
        String name = this.visitIdentifier(ctx.identifier());
        List<Expression> args = this.expressions(ctx.booleanExpression());
        if ("count".equals(EsqlFunctionRegistry.normalizeName(name)) && (args.isEmpty() || ctx.ASTERISK() != null)) {
            args = Collections.singletonList(new Literal(ParserUtils.source((ParserRuleContext)ctx), (Object)"*", DataTypes.KEYWORD));
        }
        return new UnresolvedFunction(ParserUtils.source((ParserRuleContext)ctx), name, FunctionResolutionStrategy.DEFAULT, args);
    }

    @Override
    public Expression visitLogicalBinary(EsqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        return type == 31 ? new And(source, left, right) : new Or(source, left, right);
    }

    @Override
    public Expression visitLogicalIn(EsqlBaseParser.LogicalInContext ctx) {
        List<Expression> expressions = ctx.valueExpression().stream().map(this::expression).toList();
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Object e = expressions.size() == 2 ? new Equals(source, expressions.get(0), expressions.get(1)) : new In(source, expressions.get(0), expressions.subList(1, expressions.size()));
        return ctx.NOT() == null ? e : new Not(source, (Expression)e);
    }

    @Override
    public Object visitIsNull(EsqlBaseParser.IsNullContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.valueExpression());
        Source source = ParserUtils.source((ParserRuleContext)ctx.valueExpression(), (ParserRuleContext)ctx);
        return ctx.NOT() != null ? new IsNotNull(source, exp) : new IsNull(source, exp);
    }

    @Override
    public Expression visitRegexBooleanExpression(EsqlBaseParser.RegexBooleanExpressionContext ctx) {
        int type = ctx.kind.getType();
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Expression left = this.expression((ParseTree)ctx.valueExpression());
        Literal pattern = this.visitString(ctx.pattern);
        Object result = switch (type) {
            case 43 -> new WildcardLike(source, left, new WildcardPattern(pattern.fold().toString()));
            case 49 -> new RLike(source, left, new RLikePattern(pattern.fold().toString()));
            default -> throw new ParsingException("Invalid predicate type for [{}]", source.text());
        };
        return ctx.NOT() == null ? result : new Not(source, (Expression)result);
    }

    @Override
    public Order visitOrderExpression(EsqlBaseParser.OrderExpressionContext ctx) {
        return new Order(ParserUtils.source((ParserRuleContext)ctx), this.expression((ParseTree)ctx.booleanExpression()), ctx.DESC() != null ? Order.OrderDirection.DESC : Order.OrderDirection.ASC, ctx.NULLS() != null && ctx.LAST() != null || ctx.NULLS() == null && ctx.DESC() == null ? Order.NullsPosition.LAST : Order.NullsPosition.FIRST);
    }

    public NamedExpression visitProjectExpression(EsqlBaseParser.SourceIdentifierContext ctx) {
        Source src = ParserUtils.source((ParserRuleContext)ctx);
        String identifier = this.visitSourceIdentifier(ctx);
        return identifier.equals("*") ? new UnresolvedStar(src, null) : new UnresolvedAttribute(src, identifier);
    }

    @Override
    public Alias visitRenameClause(EsqlBaseParser.RenameClauseContext ctx) {
        Source src = ParserUtils.source((ParserRuleContext)ctx);
        String newName = this.visitSourceIdentifier(ctx.newName);
        String oldName = this.visitSourceIdentifier(ctx.oldName);
        if (newName.contains("*") || oldName.contains("*")) {
            throw new ParsingException(src, "Using wildcards (*) in renaming projections is not allowed [{}]", src.text());
        }
        return new Alias(src, newName, (Expression)new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx.oldName), oldName));
    }

    @Override
    public Alias visitField(EsqlBaseParser.FieldContext ctx) {
        UnresolvedAttribute id = this.visitQualifiedName(ctx.qualifiedName());
        Expression value = this.expression((ParseTree)ctx.booleanExpression());
        String name = id == null ? ctx.getText() : id.qualifiedName();
        return new Alias(ParserUtils.source((ParserRuleContext)ctx), name, value);
    }

    @Override
    public List<NamedExpression> visitGrouping(EsqlBaseParser.GroupingContext ctx) {
        return ctx != null ? ParserUtils.visitList((ParseTreeVisitor)this, ctx.qualifiedName(), NamedExpression.class) : Collections.emptyList();
    }

    @Override
    public Object visitInputParam(EsqlBaseParser.InputParamContext ctx) {
        DataType sourceType;
        TypedParamValue param = this.param(ctx.PARAM());
        DataType dataType = EsqlDataTypes.fromTypeName(param.type);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        if (dataType == null) {
            throw new ParsingException(source, "Invalid parameter data type [{}]", param.type);
        }
        if (param.value == null) {
            return new Literal(source, null, dataType);
        }
        try {
            sourceType = DataTypes.fromJava((Object)param.value);
        }
        catch (QlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", param.value.getClass().getName(), param.type);
        }
        if (sourceType == dataType) {
            return new Literal(source, param.value, dataType);
        }
        try {
            if (!EsqlDataTypeConverter.canConvert(sourceType, dataType)) {
                throw new ParsingException(source, "Cannot cast value [{}] of type [{}] to parameter type [{}]", param.value, sourceType, dataType);
            }
            return new Literal(source, EsqlDataTypeConverter.converterFor(sourceType, dataType).convert(param.value), dataType);
        }
        catch (QlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", sourceType, param.type);
        }
    }

    private TypedParamValue param(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        if (!this.params.containsKey(token)) {
            throw new ParsingException(ParserUtils.source((TerminalNode)node), "Unexpected parameter", new Object[0]);
        }
        return this.params.get(token);
    }
}

