/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.ql.tree.Source;

public final class MvSumIntEvaluator
extends AbstractMultivalueFunction.AbstractNullableEvaluator {
    private final Warnings warnings;
    private final DriverContext driverContext;

    public MvSumIntEvaluator(Source source, EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.warnings = new Warnings(source);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvSum";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                try {
                    int first = v.getFirstValueIndex(p);
                    int end = first + valueCount;
                    int value = v.getInt(first);
                    for (int i = first + 1; i < end; ++i) {
                        int next = v.getInt(i);
                        value = MvSum.process(value, next);
                    }
                    int result = value;
                    builder.appendInt(result);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    builder.appendNull();
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field) {
            this.source = source;
            this.field = field;
        }

        public MvSumIntEvaluator get(DriverContext context) {
            return new MvSumIntEvaluator(this.source, this.field.get(context), context);
        }

        public String toString() {
            return "MvSum[field=" + this.field + "]";
        }
    }
}

