/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;

public final class MvMinLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvMinLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvMin";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                long value = v.getLong(first);
                for (int i = first + 1; i < end; ++i) {
                    long next = v.getLong(i);
                    value = MvMin.process(value, next);
                }
                long result = value;
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                long value = v.getLong(first);
                for (int i = first + 1; i < end; ++i) {
                    long next = v.getLong(i);
                    value = MvMin.process(value, next);
                }
                long result = value;
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                long result = v.getLong(first + idx);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                long result = v.getLong(first + idx);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMinLongEvaluator get(DriverContext context) {
            return new MvMinLongEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMin[field=" + this.field + "]";
        }
    }
}

