/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Sqrt
extends UnaryScalarFunction
implements EvaluatorMapper {
    public Sqrt(Source source, @Param(name="n", type={"integer", "long", "double", "unsigned_long"}) Expression n) {
        super(source, n);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataTypes.DOUBLE) {
            return new SqrtDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.INTEGER) {
            return new SqrtIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.LONG) {
            return new SqrtLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.UNSIGNED_LONG) {
            return new SqrtUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    static double process(double val) {
        if (val < 0.0) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    static double process(long val) {
        if (val < 0L) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    static double processUnsignedLong(long val) {
        return Math.sqrt(NumericUtils.unsignedLongToDouble((long)val));
    }

    static double process(int val) {
        if (val < 0) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Sqrt(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Sqrt::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }
}

