/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.PowEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Pow
extends ScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression base;
    private final Expression exponent;
    private final DataType dataType;

    public Pow(Source source, @Param(name="base", type={"integer", "unsigned_long", "long", "double"}) Expression base, @Param(name="exponent", type={"integer", "unsigned_long", "long", "double"}) Expression exponent) {
        super(source, Arrays.asList(base, exponent));
        this.base = base;
        this.exponent = exponent;
        this.dataType = DataTypes.DOUBLE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.base, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.exponent, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.base.foldable() && this.exponent.foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static double process(double base, double exponent) {
        return NumericUtils.asFiniteNumber((double)Math.pow(base, exponent));
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Pow(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Pow::new, (Object)this.base(), (Object)this.exponent());
    }

    public Expression base() {
        return this.base;
    }

    public Expression exponent() {
        return this.exponent;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory baseEval = Cast.cast(this.source(), this.base.dataType(), DataTypes.DOUBLE, toEvaluator.apply(this.base));
        EvalOperator.ExpressionEvaluator.Factory expEval = Cast.cast(this.source(), this.exponent.dataType(), DataTypes.DOUBLE, toEvaluator.apply(this.exponent));
        return new PowEvaluator.Factory(this.source(), baseEval, expEval);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.exponent);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Pow other = (Pow)obj;
        return Objects.equals(other.base, this.base) && Objects.equals(other.exponent, this.exponent);
    }
}

