/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseEvaluator;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;

public class DateParse
extends ScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    public static final DateFormatter DEFAULT_FORMATTER = DateParse.toFormatter(new BytesRef((CharSequence)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), DateUtils.UTC);
    private final Expression field;
    private final Expression format;

    @FunctionInfo(returnType={"date"}, description="Parses a string into a date value")
    public DateParse(Source source, @Param(name="datePattern", type={"keyword"}, description="A valid date pattern", optional=true) Expression first, @Param(name="dateString", type={"keyword", "text"}, description="A string representing a date") Expression second) {
        super(source, second != null ? List.of(first, second) : List.of(first));
        this.field = second != null ? second : first;
        this.format = second != null ? first : null;
    }

    public DataType dataType() {
        return DataTypes.DATETIME;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(this.format != null ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.FIRST));
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.format != null && (resolution = TypeResolutions.isStringAndExact((Expression)this.format, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable() && (this.format == null || this.format.foldable());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    public static long process(BytesRef val, DateFormatter formatter) throws IllegalArgumentException {
        String dateString = val.utf8ToString();
        return formatter.parseMillis(dateString);
    }

    static long process(BytesRef val, BytesRef formatter, ZoneId zoneId) throws IllegalArgumentException {
        return DateParse.process(val, DateParse.toFormatter(formatter, zoneId));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        ZoneId zone = DateUtils.UTC;
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.format == null) {
            return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, DEFAULT_FORMATTER);
        }
        if (this.format.dataType() != DataTypes.KEYWORD) {
            throw new IllegalArgumentException("unsupported data type for date_parse [" + this.format.dataType() + "]");
        }
        if (this.format.foldable()) {
            try {
                DateFormatter formatter = DateParse.toFormatter(this.format.fold(), zone);
                return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException((Throwable)e, "invalid date pattern for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
            }
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(this.format);
        return new DateParseEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator, zone);
    }

    private static DateFormatter toFormatter(Object format, ZoneId zone) {
        return DateFormatter.forPattern((String)((BytesRef)format).utf8ToString()).withZone(zone);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateParse(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        Expression first = this.format != null ? this.format : this.field;
        Expression second = this.format != null ? this.field : null;
        return NodeInfo.create((Node)this, DateParse::new, (Object)first, (Object)second);
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }
}

