/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractEvaluator;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ConfigurationFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class DateExtract
extends ConfigurationFunction
implements EvaluatorMapper {
    private ChronoField chronoField;

    public DateExtract(Source source, Expression chronoFieldExp, Expression field, Configuration configuration) {
        super(source, List.of(chronoFieldExp, field), configuration);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply((Expression)this.children().get(1));
        if (((Expression)this.children().get(0)).foldable()) {
            ChronoField chrono = this.chronoField();
            if (chrono == null) {
                BytesRef field = (BytesRef)((Expression)this.children().get(0)).fold();
                throw new InvalidArgumentException("invalid date field for [{}]: {}", new Object[]{this.sourceText(), field.utf8ToString()});
            }
            return new DateExtractConstantEvaluator.Factory(this.source(), fieldEvaluator, chrono, this.configuration().zoneId());
        }
        EvalOperator.ExpressionEvaluator.Factory chronoEvaluator = toEvaluator.apply((Expression)this.children().get(0));
        return new DateExtractEvaluator.Factory(this.source(), fieldEvaluator, chronoEvaluator, this.configuration().zoneId());
    }

    private ChronoField chronoField() {
        Expression field;
        if (this.chronoField == null && (field = (Expression)this.children().get(0)).foldable() && field.dataType() == DataTypes.KEYWORD) {
            try {
                BytesRef br = BytesRefs.toBytesRef((Object)field.fold());
                this.chronoField = ChronoField.valueOf(br.utf8ToString().toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.chronoField;
    }

    static long process(long value, BytesRef chronoField, ZoneId zone) {
        ChronoField chrono = ChronoField.valueOf(chronoField.utf8ToString().toUpperCase(Locale.ROOT));
        return Instant.ofEpochMilli(value).atZone(zone).getLong(chrono);
    }

    static long process(long value, ChronoField chronoField, ZoneId zone) {
        return Instant.ofEpochMilli(value).atZone(zone).getLong(chronoField);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateExtract(this.source(), newChildren.get(0), newChildren.get(1), this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateExtract::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)), (Object)this.configuration());
    }

    public DataType dataType() {
        return DataTypes.LONG;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isStringAndExact((Expression)((Expression)this.children().get(0)), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isDate((Expression)((Expression)this.children().get(1)), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    public boolean foldable() {
        return ((Expression)this.children().get(0)).foldable() && ((Expression)this.children().get(1)).foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }
}

